/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.SnowGolemRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.SnowGolem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.thatgravyboat.winteroverhaul.WinterOverhaul;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.ReplacedSnowGolemRenderer;
import tech.thatgravyboat.winteroverhaul.common.entity.ReplacedSnowGolem;

public class RandomFaceLayer<S extends SnowGolemRenderState>
extends GeoRenderLayer<ReplacedSnowGolem, SnowGolem, S> {
    private static final DataTicket<UUID> ENTITY_UUID = DataTicket.create((String)"entity_uuid", UUID.class);
    private static final int SIZE = 12;
    private static final ResourceLocation[] TEXTURES = (ResourceLocation[])Util.make(() -> {
        ResourceLocation[] textures = new ResourceLocation[12];
        for (int i = 0; i < 12; ++i) {
            textures[i] = WinterOverhaul.id("textures/entity/faces/snow_golem_face_" + (i + 1) + ".png");
        }
        return textures;
    });

    public RandomFaceLayer(ReplacedSnowGolemRenderer entityRendererIn) {
        super((GeoRenderer)entityRendererIn);
    }

    public void addRenderData(ReplacedSnowGolem animatable, SnowGolem relatedObject, S renderState) {
        ((GeoRenderState)renderState).addGeckolibData(ENTITY_UUID, (Object)relatedObject.getUUID());
    }

    public void render(S renderState, PoseStack poseStack, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        if (((SnowGolemRenderState)renderState).isInvisible) {
            return;
        }
        if (((SnowGolemRenderState)renderState).hasPumpkin) {
            return;
        }
        UUID uuid = (UUID)((GeoRenderState)renderState).getOrDefaultGeckolibData(ENTITY_UUID, (Object)Util.NIL_UUID);
        RenderType renderType1 = RenderType.entityTranslucent((ResourceLocation)this.getRandomTexture(uuid));
        VertexConsumer consumer = bufferSource.getBuffer(renderType1);
        this.getRenderer().reRender(renderState, poseStack, bakedModel, bufferSource, renderType1, consumer, packedLight, packedOverlay, -1);
    }

    private ResourceLocation getRandomTexture(UUID uuid) {
        return TEXTURES[(int)(Math.abs(uuid.getLeastSignificantBits() ^ (uuid.getMostSignificantBits() | 0xFF00FFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) % 12L)];
    }
}

