/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.thatgravyboat.winteroverhaul.WinterOverhaul;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.ReplacedSnowGolemRenderer;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.entity.ReplacedSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;

public class UpgradeLayer<S extends EntityRenderState>
extends GeoRenderLayer<ReplacedSnowGolem, SnowGolem, S> {
    private static final DataTicket<ItemStack> SCARF_ITEM = DataTicket.create((String)"scarf_item", ItemStack.class);
    private static final DataTicket<ItemStack> FACE_ITEM = DataTicket.create((String)"face_item", ItemStack.class);
    private static final DataTicket<ItemStack> HAT_ITEM = DataTicket.create((String)"hat_item", ItemStack.class);
    private final ReplacedSnowGolemRenderer renderer;

    public UpgradeLayer(ReplacedSnowGolemRenderer entityRendererIn) {
        super((GeoRenderer)entityRendererIn);
        this.renderer = entityRendererIn;
    }

    public void addRenderData(ReplacedSnowGolem animatable, SnowGolem relatedObject, S renderState) {
        if (relatedObject instanceof IUpgradeAbleSnowGolem) {
            IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)relatedObject;
            ((GeoRenderState)renderState).addGeckolibData(SCARF_ITEM, (Object)upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.SCARF));
            ((GeoRenderState)renderState).addGeckolibData(FACE_ITEM, (Object)upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.FACE));
            ((GeoRenderState)renderState).addGeckolibData(HAT_ITEM, (Object)upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.HAT));
        }
    }

    public void render(S renderState, PoseStack poseStack, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        if (((EntityRenderState)renderState).isInvisible) {
            return;
        }
        ItemStack scarf = (ItemStack)((GeoRenderState)renderState).getOrDefaultGeckolibData(SCARF_ITEM, (Object)ItemStack.EMPTY);
        UpgradeLayer.getTexture(scarf).ifPresent(texture -> {
            RenderType translucentType = RenderType.entityTranslucent((ResourceLocation)texture);
            VertexConsumer consumer = bufferSource.getBuffer(translucentType);
            this.getRenderer().reRender((GeoRenderState)renderState, poseStack, bakedModel, bufferSource, translucentType, consumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        });
        ItemStack face = (ItemStack)((GeoRenderState)renderState).getOrDefaultGeckolibData(FACE_ITEM, (Object)ItemStack.EMPTY);
        UpgradeLayer.getTexture(face).ifPresent(texture -> {
            RenderType translucentType = RenderType.entityTranslucent((ResourceLocation)texture);
            VertexConsumer consumer = bufferSource.getBuffer(translucentType);
            this.getRenderer().reRender((GeoRenderState)renderState, poseStack, bakedModel, bufferSource, translucentType, consumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        });
        ItemStack hat = (ItemStack)((GeoRenderState)renderState).getOrDefaultGeckolibData(HAT_ITEM, (Object)ItemStack.EMPTY);
        UpgradeLayer.getTexture(hat).ifPresent(texture -> {
            RenderType translucentType = RenderType.entityTranslucent((ResourceLocation)texture);
            VertexConsumer consumer = bufferSource.getBuffer(translucentType);
            this.getRenderer().reRender((GeoRenderState)renderState, poseStack, bakedModel, bufferSource, translucentType, consumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        });
    }

    private static Optional<ResourceLocation> getTexture(ItemStack item) {
        if (item.isEmpty()) {
            return Optional.empty();
        }
        ResourceLocation itemPath = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
        if (itemPath == null) {
            return Optional.empty();
        }
        return Optional.of(WinterOverhaul.id("textures/entity/upgrades/" + itemPath.getPath() + ".png"));
    }
}

