/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity.model;

import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import tech.thatgravyboat.winteroverhaul.WinterOverhaul;
import tech.thatgravyboat.winteroverhaul.common.entity.ReplacedSnowGolem;

public class ReplacedSnowGolemModel<E extends ReplacedSnowGolem>
extends GeoModel<E> {
    private static final ResourceLocation BASE_TEXTURE = WinterOverhaul.id("textures/entity/snow_golem.png");
    private static final ResourceLocation MODEL = WinterOverhaul.id("snow_golem");
    private static final ResourceLocation ANIMATION = WinterOverhaul.id("snow_golem");

    public ResourceLocation getModelResource(GeoRenderState renderState) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(GeoRenderState animatable) {
        return BASE_TEXTURE;
    }

    public ResourceLocation getAnimationResource(E animatable) {
        return ANIMATION;
    }

    public void setCustomAnimations(AnimationState<E> animationState) {
        super.setCustomAnimations(animationState);
        if (animationState == null) {
            return;
        }
        float netHeadYaw = ((Float)animationState.getDataOrDefault(DataTickets.ENTITY_YAW, (Object)Float.valueOf(0.0f))).floatValue();
        float headPitch = ((Float)animationState.getDataOrDefault(DataTickets.ENTITY_PITCH, (Object)Float.valueOf(0.0f))).floatValue();
        GeoBone head = this.getAnimationProcessor().getBone("head");
        head.setRotY(netHeadYaw * ((float)Math.PI / 180));
        head.setRotX(headPitch * ((float)Math.PI / 180));
        GeoBone upperBody = this.getAnimationProcessor().getBone("body_2");
        upperBody.setRotY(netHeadYaw * ((float)Math.PI / 180) * 0.25f);
    }
}

