/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.common.entity;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;

public class GolemRangedAttackGoal
extends Goal {
    private final SnowGolem snowGolem;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int interval;
    private final float attackRadius;

    public GolemRangedAttackGoal(SnowGolem snowGolem, double pSpeedModifier, int interval, float pAttackRadius) {
        this.snowGolem = snowGolem;
        this.speedModifier = pSpeedModifier;
        this.interval = interval;
        this.attackRadius = pAttackRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingentity = this.snowGolem.getTarget();
        if (livingentity != null && livingentity.isAlive()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() || !this.snowGolem.getNavigation().isDone();
    }

    public void stop() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public int getInterval() {
        SnowGolem snowGolem = this.snowGolem;
        if (!(snowGolem instanceof IUpgradeAbleSnowGolem)) {
            return this.interval;
        }
        IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)snowGolem;
        Item scarf = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.SCARF).getItem();
        Item hat = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.HAT).getItem();
        int amount = 1;
        amount += scarf.equals(ModItems.CYAN_SCARF.get()) ? 1 : 0;
        return this.interval / (amount += hat.equals(ModItems.CYAN_HAT.get()) ? 1 : 0);
    }

    public float getAttackRadius() {
        SnowGolem snowGolem = this.snowGolem;
        if (!(snowGolem instanceof IUpgradeAbleSnowGolem)) {
            return this.interval;
        }
        IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)snowGolem;
        Item scarf = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.SCARF).getItem();
        Item hat = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.HAT).getItem();
        float amount = 1.0f;
        amount += scarf.equals(ModItems.GREEN_SCARF.get()) ? 0.5f : 0.0f;
        return this.attackRadius * (amount += hat.equals(ModItems.GREEN_HAT.get()) ? 0.5f : 0.0f);
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
        double d0 = this.snowGolem.distanceToSqr((Entity)this.target);
        boolean flag = this.snowGolem.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        float attackRadius = this.getAttackRadius();
        if (!(d0 > (double)(attackRadius * attackRadius)) && this.seeTime >= 5) {
            this.snowGolem.getNavigation().stop();
        } else {
            this.snowGolem.getNavigation().moveTo((Entity)this.target, this.speedModifier);
        }
        this.snowGolem.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!flag) {
                return;
            }
            float f = (float)Math.sqrt(d0) / attackRadius;
            float f1 = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
            this.snowGolem.performRangedAttack(this.target, f1);
            this.attackTime = Mth.floor((float)this.getInterval());
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.floor((float)this.getInterval());
        }
    }
}

