/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animatable.processing.AnimationTest;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.thatgravyboat.winteroverhaul.common.registry.ModEntities;
import tech.thatgravyboat.winteroverhaul.common.registry.ModSounds;

public class Robin
extends Animal
implements FlyingAnimal,
GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public static final RawAnimation IDLE_1 = RawAnimation.begin().thenPlayAndHold("robin_idle_1");
    public static final RawAnimation IDLE_2 = RawAnimation.begin().thenPlayAndHold("robin_idle_2");
    public static final RawAnimation IDLE_3 = RawAnimation.begin().thenPlayAndHold("robin_idle_3");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("robin_walk");
    public static final RawAnimation FLY = RawAnimation.begin().thenLoop("robin_fly");

    public Robin(EntityType<? extends Animal> entity, Level level) {
        super(entity, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.FLYING_SPEED, 0.4).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.setCanFloat(true);
        return flyingpathnavigation;
    }

    public void aiStep() {
        super.aiStep();
        this.calculateFlapping();
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.onGround() && !this.isPassenger() ? 4 : -1) * 0.3);
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    protected void onFlap() {
        this.playSound(SoundEvents.PARROT_FLY, 0.15f, 1.0f);
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    public boolean causeFallDamage(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double pY, boolean pOnGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public boolean doHurtTarget(ServerLevel level, Entity source) {
        return source.hurtServer(level, this.damageSources().mobAttack((LivingEntity)this), 3.0f);
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.ROBIN_AMBIENT.get();
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.SWEET_BERRIES);
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return (AgeableMob)((EntityType)ModEntities.ROBIN.get()).create((Level)level, EntitySpawnReason.BREEDING);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    private <E extends GeoAnimatable> PlayState idle(AnimationTest<E> event) {
        boolean fiveCheck;
        boolean isRunning;
        AnimationController.State state = event.controller().getAnimationState();
        boolean bl = isRunning = !state.equals((Object)AnimationController.State.STOPPED) && !state.equals((Object)AnimationController.State.PAUSED);
        if (this.isFlying()) {
            event.controller().forceAnimationReset();
            return PlayState.STOP;
        }
        if (isRunning) {
            return PlayState.CONTINUE;
        }
        boolean threeCheck = this.tickCount % 60 == 0 && this.random.nextBoolean();
        boolean fourCheck = this.tickCount % 80 == 0 && this.random.nextBoolean();
        boolean bl2 = fiveCheck = this.tickCount % 100 == 0;
        if (threeCheck || fourCheck || fiveCheck) {
            switch (this.random.nextInt(3)) {
                case 0: {
                    event.controller().setAnimation(IDLE_1);
                    return PlayState.CONTINUE;
                }
                case 1: {
                    event.controller().setAnimation(IDLE_2);
                    return PlayState.CONTINUE;
                }
            }
            event.controller().setAnimation(IDLE_3);
            return PlayState.CONTINUE;
        }
        event.controller().forceAnimationReset();
        return PlayState.STOP;
    }

    private <E extends GeoAnimatable> PlayState walking(AnimationTest<E> event) {
        if (event.isMoving() && !this.isFlying()) {
            event.controller().setAnimation(WALK);
            return PlayState.CONTINUE;
        }
        event.controller().forceAnimationReset();
        return PlayState.STOP;
    }

    private <E extends GeoAnimatable> PlayState flying(AnimationTest<E> event) {
        if (this.isFlying()) {
            event.controller().setAnimation(FLY);
            return PlayState.CONTINUE;
        }
        event.controller().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("flight_controller", 0, this::flying));
        controllers.add(new AnimationController("walk_controller", 0, this::walking));
        controllers.add(new AnimationController("idle_controller", 5, this::idle));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

