/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.items.SkateItem;
import tech.thatgravyboat.winteroverhaul.common.registry.ModBlockTags;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;
import tech.thatgravyboat.winteroverhaul.mixin.AccessorEntity;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    public MixinLivingEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"getBlockSpeedFactor()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity;
        boolean isWearingBoots;
        BlockState state = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement());
        boolean isIce = state.is(ModBlockTags.ICE);
        MixinLivingEntity mixinLivingEntity = this;
        boolean bl = isWearingBoots = mixinLivingEntity instanceof LivingEntity && (livingEntity = (LivingEntity)mixinLivingEntity).getItemBySlot(EquipmentSlot.FEET).getItem() instanceof SkateItem;
        if (isIce && isWearingBoots) {
            cir.setReturnValue((Object)Float.valueOf(1.05f));
        }
    }

    @ModifyVariable(method={"travelInAir(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="STORE"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getBlockPosBelowThatAffectsMyMovement()Lnet/minecraft/core/BlockPos;"), to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;handleRelativeFrictionAndCalculateMovement(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;")), ordinal=0)
    private float changeFriction(float friction) {
        LivingEntity livingEntity;
        MixinLivingEntity mixinLivingEntity;
        BlockState state = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement());
        boolean isIce = state.is(ModBlockTags.ICE);
        if (isIce && !this.isSprinting() && (mixinLivingEntity = this) instanceof LivingEntity && (livingEntity = (LivingEntity)mixinLivingEntity).getItemBySlot(EquipmentSlot.FEET).getItem() instanceof SkateItem) {
            return 0.8f;
        }
        return friction;
    }

    @ModifyExpressionValue(method={"aiStep()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWaterOrRain()Z")})
    private boolean disableDamageFromRainIfWearingTopHat(boolean original) {
        MixinLivingEntity mixinLivingEntity = this;
        if (mixinLivingEntity instanceof SnowGolem) {
            SnowGolem snowGolem = (SnowGolem)mixinLivingEntity;
            if (original && ((AccessorEntity)((Object)this)).callIsInRain() && !this.isInWater() && ((IUpgradeAbleSnowGolem)snowGolem).getGolemUpgradeInSlot(GolemUpgradeSlot.HAT).is((Item)ModItems.TOP_HAT.get())) {
                return false;
            }
        }
        return original;
    }
}

