/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tech.thatgravyboat.winteroverhaul.common.entity.GolemAttackableTargetGoal;
import tech.thatgravyboat.winteroverhaul.common.entity.GolemRangedAttackGoal;
import tech.thatgravyboat.winteroverhaul.common.entity.GolemUpgradeAttachmentHelper;
import tech.thatgravyboat.winteroverhaul.common.entity.ISnowGolemSnowball;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeItem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;
import tech.thatgravyboat.winteroverhaul.common.registry.ModParticles;

@Mixin(value={SnowGolem.class})
public abstract class MixinSnowGolem
extends Mob
implements IUpgradeAbleSnowGolem {
    protected MixinSnowGolem(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    @Inject(method={"aiStep()V"}, at={@At(value="HEAD")})
    private void onAiStep(CallbackInfo ci) {
        SnowGolem golem = (SnowGolem)this;
        if (!golem.level().isClientSide) {
            if (this.winteroverhaul_getUpgrades() != null) {
                this.winteroverhaul_getUpgrades().forEach(stack -> {
                    Item patt0$temp = stack.getItem();
                    if (patt0$temp instanceof GolemUpgradeItem) {
                        GolemUpgradeItem upgradeItem = (GolemUpgradeItem)patt0$temp;
                        upgradeItem.tick((ItemStack)stack, golem);
                    }
                });
            }
        } else if (this.tickCount % 2 == 0) {
            float health = golem.getHealth() / golem.getMaxHealth();
            SimpleParticleType particleType = health >= 0.6f ? (SimpleParticleType)ModParticles.SNOWFLAKE_1.get() : ((double)health >= 0.3 ? (SimpleParticleType)ModParticles.SNOWFLAKE_2.get() : (SimpleParticleType)ModParticles.SNOWFLAKE_3.get());
            this.level().addParticle((ParticleOptions)particleType, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }

    @Inject(method={"registerGoals()V"}, at={@At(value="TAIL")})
    private void changeRangeAttackGoal(CallbackInfo ci) {
        SnowGolem golem = (SnowGolem)this;
        this.goalSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof RangedAttackGoal);
        this.goalSelector.addGoal(1, (Goal)new GolemRangedAttackGoal(golem, 1.25, 20, 10.0f));
        this.targetSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof NearestAttackableTargetGoal);
        this.targetSelector.addGoal(1, new GolemAttackableTargetGoal<Mob>(this, Mob.class, 10, true, false, (entity, level) -> entity instanceof Enemy));
    }

    @ModifyExpressionValue(method={"performRangedAttack(Lnet/minecraft/world/entity/LivingEntity;F)V"}, at={@At(value="NEW", target="(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/projectile/Snowball;")})
    private Snowball onSnowballCreation(Snowball snowball) {
        if (snowball instanceof ISnowGolemSnowball) {
            Item face;
            ISnowGolemSnowball snowGolemSnowball = (ISnowGolemSnowball)snowball;
            snowGolemSnowball.winteroverhaul_setGolemSnowball(true);
            Item scraf = this.getGolemUpgradeInSlot(GolemUpgradeSlot.SCARF).getItem();
            Item hat = this.getGolemUpgradeInSlot(GolemUpgradeSlot.HAT).getItem();
            int amount = hat.equals(ModItems.RED_HAT.get()) ? 2 : 0;
            if ((amount += scraf.equals(ModItems.RED_SCARF.get()) ? 2 : 0) > 0) {
                snowGolemSnowball.winteroverhaul_setGolemMultiplier(amount);
            }
            if ((face = this.getGolemUpgradeInSlot(GolemUpgradeSlot.FACE).getItem()).equals(Items.CARROT) || face.equals(Items.GOLDEN_CARROT)) {
                snowGolemSnowball.winteroverhaul_addMobEffect(new MobEffectInstance(MobEffects.SLOWNESS, 20, 1));
                if (face.equals(Items.GOLDEN_CARROT)) {
                    snowGolemSnowball.winteroverhaul_addMobEffect(new MobEffectInstance(MobEffects.WEAKNESS, 20, 4));
                }
            }
        }
        return snowball;
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="TAIL")})
    private void onSaveNbt(ValueOutput output, CallbackInfo ci) {
        output.store("GolemUpgrades", GolemUpgradeAttachmentHelper.CODEC, (Object)this.winteroverhaul_getUpgrades());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    private void onLoadNbt(ValueInput input, CallbackInfo ci) {
        this.winteroverhaul_setUpgrades(input.read("GolemUpgrades", GolemUpgradeAttachmentHelper.CODEC).orElse(GolemUpgradeAttachmentHelper.createDefault()));
    }

    @Override
    public ItemStack setGolemUpgradeInSlot(GolemUpgradeSlot slot, ItemStack stack) {
        ItemStack oldStack = (ItemStack)this.winteroverhaul_getUpgrades().set(slot.index, (Object)stack);
        this.winteroverhaul_updateUpgrades();
        return oldStack;
    }

    @Override
    public ItemStack getGolemUpgradeInSlot(GolemUpgradeSlot slot) {
        return (ItemStack)this.winteroverhaul_getUpgrades().get(slot.index);
    }
}

