/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.neoforge;

import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import tech.thatgravyboat.winteroverhaul.WinterOverhaul;
import tech.thatgravyboat.winteroverhaul.common.util.BiomeSpawns;
import tech.thatgravyboat.winteroverhaul.neoforge.WinterOverhaulAttachmentTypes;
import tech.thatgravyboat.winteroverhaul.neoforge.WinterOverhaulModBusEvents;

@Mod(value="winteroverhaul")
public class WinterOverhaulNeoForge {
    public static final WinterOverhaul MOD = new WinterOverhaul();
    private static final BiomeSpawns biomeSpawns = new BiomeSpawns();

    public WinterOverhaulNeoForge(IEventBus modBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modBus.register(WinterOverhaulModBusEvents.class);
        MOD.register();
        WinterOverhaulAttachmentTypes.ATTACHMENT_TYPES.register(modBus);
    }

    @SubscribeEvent
    public void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        InteractionResult result = MOD.onEntityRightClick(event.getTarget(), event.getItemStack(), event.getEntity());
        if (result != InteractionResult.PASS) {
            event.setCancellationResult(result);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(MobSpawnEvent.PositionCheck event) {
        MOD.onEntitySpawn((LivingEntity)event.getEntity(), (LevelReader)event.getLevel());
    }

    @SubscribeEvent
    public void onAddSpawns(LevelEvent.PotentialSpawns potentialSpawns) {
        if (biomeSpawns.getSpawns().isEmpty()) {
            MOD.addSpawns(biomeSpawns);
        }
        for (BiomeSpawns.SpawnData spawn : biomeSpawns.getSpawns()) {
            if (potentialSpawns.getMobCategory() != spawn.category() || !spawn.selector().test((Holder<Biome>)potentialSpawns.getLevel().getBiome(potentialSpawns.getPos()))) continue;
            potentialSpawns.addSpawnerData(spawn.spawnerData());
        }
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        MOD.onMobDrops(event.getEntity(), event.getDrops());
    }

    @SubscribeEvent
    public void onEntityDamage(LivingIncomingDamageEvent event) {
        if (MOD.onEntityDamage((Entity)event.getEntity(), event.getSource())) {
            event.setCanceled(true);
        }
    }
}

