/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul;

import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.entity.Robin;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.registry.ModEntities;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;
import tech.thatgravyboat.winteroverhaul.common.registry.ModParticles;
import tech.thatgravyboat.winteroverhaul.common.registry.ModSounds;
import tech.thatgravyboat.winteroverhaul.common.util.BiomeSpawns;
import tech.thatgravyboat.winteroverhaul.common.util.EntityAttributesBuilder;

public class WinterOverhaul {
    public static final String MODID = "winteroverhaul";
    public static final Logger LOGGER = LogManager.getLogger();

    public void register() {
        ModItems.ITEMS.register();
        ModParticles.PARTICLES.register();
        ModEntities.ENTITIES.register();
        ModSounds.SOUNDS.register();
        SpawnPlacementsRegistry.register(ModEntities.ROBIN, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (entity, level, spawn, pos, random) -> {
            BlockState state = level.m_8055_(pos.m_7495_());
            boolean isLeaves = state.m_204336_(BlockTags.f_13035_);
            boolean isSnow = state.m_204336_(BlockTags.f_144279_);
            boolean isGrass = state.m_60713_(Blocks.f_50440_);
            return (isLeaves || isSnow || isGrass || state.m_60795_()) && level.m_45524_(pos, 0) > 8;
        });
    }

    public InteractionResult onEntityRightClick(Entity target, ItemStack stack, Player player) {
        SnowGolem snowGolem;
        if (!(target instanceof SnowGolem) || (snowGolem = (SnowGolem)target).m_29930_()) {
            return InteractionResult.PASS;
        }
        if (!(snowGolem instanceof IUpgradeAbleSnowGolem)) {
            return InteractionResult.PASS;
        }
        IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)snowGolem;
        if (stack.m_150930_(Items.f_42619_) || stack.m_150930_(Items.f_42677_)) {
            ItemStack oldItem = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.FACE);
            if (!oldItem.m_41619_()) {
                player.m_36176_(oldItem, true);
            }
            ItemStack newStack = stack.m_41777_();
            newStack.m_41764_(1);
            upgradeAbleSnowGolem.setGolemUpgradeInSlot(GolemUpgradeSlot.FACE, newStack);
            stack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
        }
        if (stack.m_41619_() && player.m_6144_()) {
            for (GolemUpgradeSlot value : GolemUpgradeSlot.values()) {
                ItemStack oldStack = upgradeAbleSnowGolem.setGolemUpgradeInSlot(value, ItemStack.f_41583_);
                if (oldStack.m_41619_()) continue;
                player.m_36176_(oldStack, true);
            }
            return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void onEntitySpawn(LivingEntity entity, LevelReader level) {
        Holder biome;
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        EntityType type = mob.m_6095_();
        boolean isSkeleton = type.equals(EntityType.f_20524_) || type.equals(EntityType.f_20481_);
        boolean isZombie = type.equals(EntityType.f_20501_);
        if ((isSkeleton || isZombie) && !mob.m_6162_() && (biome = level.m_7062_().m_204214_(entity.m_20183_())).m_203633_() && ((Biome)biome.m_203334_()).m_264473_() && ((Biome)biome.m_203334_()).m_264600_(entity.m_20183_()).equals((Object)Biome.Precipitation.SNOW) && mob.m_217043_().m_188501_() > 0.9f && mob.m_217043_().m_188501_() > 0.5f) {
            Item item = WinterOverhaul.getRandomHatAndScarf(mob.m_217043_().m_188503_(8));
            mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)item));
        }
    }

    public void addSpawns(BiomeSpawns spawns) {
        spawns.addSpawn(biome -> biome.m_203656_(BiomeTags.f_207609_) && ((Biome)biome.m_203334_()).m_47554_() < 0.15f, MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ROBIN.get(), 25, 1, 2));
    }

    public void onMobDrops(LivingEntity livingEntity, Collection<ItemEntity> drops) {
        if (livingEntity instanceof IUpgradeAbleSnowGolem) {
            IUpgradeAbleSnowGolem golem = (IUpgradeAbleSnowGolem)livingEntity;
            for (GolemUpgradeSlot value : GolemUpgradeSlot.values()) {
                ItemStack stack = golem.getGolemUpgradeInSlot(value);
                BlockPos pos = livingEntity.m_20183_();
                if (stack.m_41619_()) continue;
                drops.add(new ItemEntity(livingEntity.m_9236_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack.m_41777_()));
            }
        }
    }

    public boolean onEntityDamage(Entity entity, DamageSource source) {
        return entity instanceof SnowGolem && source.m_7640_() instanceof Snowball;
    }

    public void addAttributes(EntityAttributesBuilder builder) {
        builder.register((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ROBIN.get()), Robin.createAttributes().m_22265_());
    }

    public void onComplete() {
        CauldronInteraction.f_175607_.put((Item)ModItems.SKATES.get(), CauldronInteraction.f_175615_);
    }

    private static Item getRandomHatAndScarf(int randomInt) {
        return switch (randomInt) {
            case 0 -> (Item)ModItems.GREEN_HAT.get();
            case 1 -> (Item)ModItems.GREEN_SCARF.get();
            case 2 -> (Item)ModItems.YELLOW_HAT.get();
            case 3 -> (Item)ModItems.YELLOW_SCARF.get();
            case 4 -> (Item)ModItems.RED_HAT.get();
            case 5 -> (Item)ModItems.RED_SCARF.get();
            case 6 -> (Item)ModItems.CYAN_HAT.get();
            default -> (Item)ModItems.CYAN_SCARF.get();
        };
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MODID, path);
    }
}

