/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.common.entity;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;

public class GolemRangedAttackGoal
extends Goal {
    private final SnowGolem snowGolem;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int interval;
    private final float attackRadius;

    public GolemRangedAttackGoal(SnowGolem snowGolem, double pSpeedModifier, int interval, float pAttackRadius) {
        this.snowGolem = snowGolem;
        this.speedModifier = pSpeedModifier;
        this.interval = interval;
        this.attackRadius = pAttackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.snowGolem.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.snowGolem.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean m_183429_() {
        return true;
    }

    public int getInterval() {
        SnowGolem snowGolem = this.snowGolem;
        if (!(snowGolem instanceof IUpgradeAbleSnowGolem)) {
            return this.interval;
        }
        IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)snowGolem;
        Item scarf = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.SCARF).m_41720_();
        Item hat = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.HAT).m_41720_();
        int amount = 1;
        amount += scarf.equals(ModItems.CYAN_SCARF.get()) ? 1 : 0;
        return this.interval / (amount += hat.equals(ModItems.CYAN_HAT.get()) ? 1 : 0);
    }

    public float getAttackRadius() {
        SnowGolem snowGolem = this.snowGolem;
        if (!(snowGolem instanceof IUpgradeAbleSnowGolem)) {
            return this.interval;
        }
        IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)snowGolem;
        Item scarf = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.SCARF).m_41720_();
        Item hat = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.HAT).m_41720_();
        float amount = 1.0f;
        amount += scarf.equals(ModItems.GREEN_SCARF.get()) ? 0.5f : 0.0f;
        return this.attackRadius * (amount += hat.equals(ModItems.GREEN_HAT.get()) ? 0.5f : 0.0f);
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        double d0 = this.snowGolem.m_20280_((Entity)this.target);
        boolean flag = this.snowGolem.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        float attackRadius = this.getAttackRadius();
        if (!(d0 > (double)(attackRadius * attackRadius)) && this.seeTime >= 5) {
            this.snowGolem.m_21573_().m_26573_();
        } else {
            this.snowGolem.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        }
        this.snowGolem.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!flag) {
                return;
            }
            float f = (float)Math.sqrt(d0) / attackRadius;
            float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
            this.snowGolem.m_6504_(this.target, f1);
            this.attackTime = Mth.m_14143_((float)this.getInterval());
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.m_14143_((float)this.getInterval());
        }
    }
}

