/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.thatgravyboat.winteroverhaul.common.registry.ModEntities;
import tech.thatgravyboat.winteroverhaul.common.registry.ModSounds;

public class Robin
extends Animal
implements FlyingAnimal,
GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public static final RawAnimation IDLE_1 = RawAnimation.begin().thenPlayAndHold("robin_idle_1");
    public static final RawAnimation IDLE_2 = RawAnimation.begin().thenPlayAndHold("robin_idle_2");
    public static final RawAnimation IDLE_3 = RawAnimation.begin().thenPlayAndHold("robin_idle_3");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("robin_walk");
    public static final RawAnimation FLY = RawAnimation.begin().thenLoop("robin_fly");

    public Robin(EntityType<? extends Animal> entity, Level level) {
        super(entity, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_8107_() {
        super.m_8107_();
        this.calculateFlapping();
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.m_20096_() && !this.m_20159_() ? 4 : -1) * 0.3);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.m_5496_(SoundEvents.f_12191_, 0.15f, 1.0f);
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource source) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public boolean m_7327_(Entity pEntity) {
        return pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 3.0f);
    }

    @Nullable
    public SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ROBIN_AMBIENT.get();
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42780_);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return (AgeableMob)((EntityType)ModEntities.ROBIN.get()).m_20615_((Level)level);
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    private <E extends GeoAnimatable> PlayState idle(AnimationState<E> event) {
        boolean fiveCheck;
        boolean isRunning;
        AnimationController.State state = event.getController().getAnimationState();
        boolean bl = isRunning = !state.equals((Object)AnimationController.State.STOPPED) && !state.equals((Object)AnimationController.State.PAUSED);
        if (this.m_29443_()) {
            event.getController().forceAnimationReset();
            return PlayState.STOP;
        }
        if (isRunning) {
            return PlayState.CONTINUE;
        }
        boolean threeCheck = this.f_19797_ % 60 == 0 && this.f_19796_.m_188499_();
        boolean fourCheck = this.f_19797_ % 80 == 0 && this.f_19796_.m_188499_();
        boolean bl2 = fiveCheck = this.f_19797_ % 100 == 0;
        if (threeCheck || fourCheck || fiveCheck) {
            switch (this.f_19796_.m_188503_(3)) {
                case 0: {
                    event.getController().setAnimation(IDLE_1);
                    return PlayState.CONTINUE;
                }
                case 1: {
                    event.getController().setAnimation(IDLE_2);
                    return PlayState.CONTINUE;
                }
            }
            event.getController().setAnimation(IDLE_3);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private <E extends GeoAnimatable> PlayState walking(AnimationState<E> event) {
        if (event.isMoving() && !this.m_29443_()) {
            event.getController().setAnimation(WALK);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private <E extends GeoAnimatable> PlayState flying(AnimationState<E> event) {
        if (this.m_29443_()) {
            event.getController().setAnimation(FLY);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "flight_controller", 0, this::flying)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walk_controller", 0, this::walking)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle_controller", 5, this::idle)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

