/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tech.thatgravyboat.winteroverhaul.common.entity.GolemAttackableTargetGoal;
import tech.thatgravyboat.winteroverhaul.common.entity.GolemRangedAttackGoal;
import tech.thatgravyboat.winteroverhaul.common.entity.ISnowGolemSnowball;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeItem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;
import tech.thatgravyboat.winteroverhaul.common.registry.ModParticles;

@Mixin(value={SnowGolem.class})
public abstract class MixinSnowGolem
extends Mob
implements IUpgradeAbleSnowGolem {
    @Unique
    private final NonNullList<ItemStack> winteroverhaul_upgrades = NonNullList.m_122780_((int)GolemUpgradeSlot.values().length, (Object)ItemStack.f_41583_);
    @Unique
    private static final EntityDataAccessor<ItemStack> WINTEROVERHAUL_HAT = SynchedEntityData.m_135353_(SnowGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @Unique
    private static final EntityDataAccessor<ItemStack> WINTEROVERHAUL_FACE = SynchedEntityData.m_135353_(SnowGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @Unique
    private static final EntityDataAccessor<ItemStack> WINTEROVERHAUL_SCARF = SynchedEntityData.m_135353_(SnowGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    protected MixinSnowGolem(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    @Inject(method={"m_8097_()V"}, at={@At(value="TAIL")})
    private void registerWinterOverhaulData(CallbackInfo ci) {
        this.m_20088_().m_135372_(WINTEROVERHAUL_HAT, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(WINTEROVERHAUL_FACE, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(WINTEROVERHAUL_SCARF, (Object)ItemStack.f_41583_);
    }

    @Inject(method={"m_8107_()V"}, at={@At(value="HEAD")})
    private void onAiStep(CallbackInfo ci) {
        SnowGolem golem = (SnowGolem)this;
        if (!golem.m_9236_().f_46443_) {
            if (this.winteroverhaul_upgrades != null) {
                this.winteroverhaul_upgrades.forEach(stack -> {
                    Item patt3579$temp = stack.m_41720_();
                    if (patt3579$temp instanceof GolemUpgradeItem) {
                        GolemUpgradeItem upgradeItem = (GolemUpgradeItem)patt3579$temp;
                        upgradeItem.tick((ItemStack)stack, golem);
                    }
                });
            }
        } else if (this.f_19797_ % 2 == 0) {
            float health = golem.m_21223_() / golem.m_21233_();
            SimpleParticleType particleType = health >= 0.6f ? (SimpleParticleType)ModParticles.SNOWFLAKE_1.get() : ((double)health >= 0.3 ? (SimpleParticleType)ModParticles.SNOWFLAKE_2.get() : (SimpleParticleType)ModParticles.SNOWFLAKE_3.get());
            this.m_9236_().m_7106_((ParticleOptions)particleType, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    @Inject(method={"m_8099_()V"}, at={@At(value="TAIL")})
    private void changeRangeAttackGoal(CallbackInfo ci) {
        SnowGolem golem = (SnowGolem)this;
        this.f_21345_.m_148105_().removeIf(goal -> goal.m_26015_() instanceof RangedAttackGoal);
        this.f_21345_.m_25352_(1, (Goal)new GolemRangedAttackGoal(golem, 1.25, 20, 10.0f));
        this.f_21346_.m_148105_().removeIf(goal -> goal.m_26015_() instanceof NearestAttackableTargetGoal);
        this.f_21346_.m_25352_(1, new GolemAttackableTargetGoal<Mob>(this, Mob.class, 10, true, false, entity -> entity instanceof Enemy));
    }

    @Inject(method={"m_6504_(Lnet/minecraft/world/entity/LivingEntity;F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;m_20188_()D")})
    private void onSnowballCreation(LivingEntity pTarget, float pDistanceFactor, CallbackInfo ci, @Local Snowball snowball) {
        if (snowball instanceof ISnowGolemSnowball) {
            Item face;
            ISnowGolemSnowball snowGolemSnowball = (ISnowGolemSnowball)snowball;
            snowGolemSnowball.winteroverhaul_setGolemSnowball(true);
            Item scraf = this.getGolemUpgradeInSlot(GolemUpgradeSlot.SCARF).m_41720_();
            Item hat = this.getGolemUpgradeInSlot(GolemUpgradeSlot.HAT).m_41720_();
            int amount = hat.equals(ModItems.RED_HAT.get()) ? 2 : 0;
            if ((amount += scraf.equals(ModItems.RED_SCARF.get()) ? 2 : 0) > 0) {
                snowGolemSnowball.winteroverhaul_setGolemMultiplier(amount);
            }
            if ((face = this.getGolemUpgradeInSlot(GolemUpgradeSlot.FACE).m_41720_()).equals(Items.f_42619_) || face.equals(Items.f_42677_)) {
                snowGolemSnowball.winteroverhaul_addMobEffect(new MobEffectInstance(MobEffects.f_19597_, 20, 1));
                if (face.equals(Items.f_42677_)) {
                    snowGolemSnowball.winteroverhaul_addMobEffect(new MobEffectInstance(MobEffects.f_19613_, 20, 4));
                }
            }
        }
    }

    @Inject(method={"m_7380_(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void onSaveNbt(CompoundTag pCompound, CallbackInfo ci) {
        ListTag listtag = new ListTag();
        if (this.winteroverhaul_upgrades != null) {
            for (ItemStack itemstack : this.winteroverhaul_upgrades) {
                CompoundTag compoundtag = new CompoundTag();
                if (!itemstack.m_41619_()) {
                    itemstack.m_41739_(compoundtag);
                }
                listtag.add((Object)compoundtag);
            }
            this.winteroverhaul_updateUpgrades();
        }
        pCompound.m_128365_("GolemUpgrades", (Tag)listtag);
    }

    @Inject(method={"m_7378_(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void onLoadNbt(CompoundTag pCompound, CallbackInfo ci) {
        if (pCompound.m_128425_("GolemUpgrades", 9)) {
            ListTag listtag = pCompound.m_128437_("GolemUpgrades", 10);
            if (this.winteroverhaul_upgrades != null) {
                for (int i = 0; i < this.winteroverhaul_upgrades.size(); ++i) {
                    CompoundTag itemTag = listtag.m_128728_(i);
                    if (itemTag.m_128456_()) continue;
                    this.winteroverhaul_upgrades.set(i, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
                }
                this.winteroverhaul_updateUpgrades();
            }
        }
    }

    @Override
    public ItemStack setGolemUpgradeInSlot(GolemUpgradeSlot slot, ItemStack stack) {
        if (this.winteroverhaul_upgrades == null) {
            return ItemStack.f_41583_;
        }
        ItemStack oldStack = (ItemStack)this.winteroverhaul_upgrades.set(slot.index, (Object)stack);
        this.winteroverhaul_updateUpgrades();
        return oldStack;
    }

    @Override
    public ItemStack getGolemUpgradeInSlot(GolemUpgradeSlot slot) {
        return switch (slot) {
            default -> throw new IncompatibleClassChangeError();
            case GolemUpgradeSlot.HAT -> (ItemStack)this.m_20088_().m_135370_(WINTEROVERHAUL_HAT);
            case GolemUpgradeSlot.FACE -> (ItemStack)this.m_20088_().m_135370_(WINTEROVERHAUL_FACE);
            case GolemUpgradeSlot.SCARF -> (ItemStack)this.m_20088_().m_135370_(WINTEROVERHAUL_SCARF);
        };
    }

    @Unique
    private void winteroverhaul_updateUpgrades() {
        if (this.winteroverhaul_upgrades == null) {
            return;
        }
        this.m_20088_().m_135381_(WINTEROVERHAUL_HAT, (Object)((ItemStack)this.winteroverhaul_upgrades.get(GolemUpgradeSlot.HAT.index)));
        this.m_20088_().m_135381_(WINTEROVERHAUL_FACE, (Object)((ItemStack)this.winteroverhaul_upgrades.get(GolemUpgradeSlot.FACE.index)));
        this.m_20088_().m_135381_(WINTEROVERHAUL_SCARF, (Object)((ItemStack)this.winteroverhaul_upgrades.get(GolemUpgradeSlot.SCARF.index)));
    }
}

