/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul;

import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import java.util.Collection;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1473;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1680;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_5483;
import net.minecraft.class_5620;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.entity.Robin;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.registry.ModEntities;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;
import tech.thatgravyboat.winteroverhaul.common.registry.ModParticles;
import tech.thatgravyboat.winteroverhaul.common.registry.ModSounds;
import tech.thatgravyboat.winteroverhaul.common.util.BiomeSpawns;
import tech.thatgravyboat.winteroverhaul.common.util.EntityAttributesBuilder;

public class WinterOverhaul {
    public static final String MODID = "winteroverhaul";
    public static final Logger LOGGER = LogManager.getLogger();

    public void register() {
        ModItems.ITEMS.register();
        ModParticles.PARTICLES.register();
        ModEntities.ENTITIES.register();
        ModSounds.SOUNDS.register();
        SpawnPlacementsRegistry.register(ModEntities.ROBIN, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13197, (entity, level, spawn, pos, random) -> {
            class_2680 state = level.method_8320(pos.method_10074());
            boolean isLeaves = state.method_26164(class_3481.field_15503);
            boolean isSnow = state.method_26164(class_3481.field_29823);
            boolean isGrass = state.method_27852(class_2246.field_10219);
            return (isLeaves || isSnow || isGrass || state.method_26215()) && level.method_22335(pos, 0) > 8;
        });
    }

    public class_1269 onEntityRightClick(class_1297 target, class_1799 stack, class_1657 player) {
        class_1473 snowGolem;
        if (!(target instanceof class_1473) || (snowGolem = (class_1473)target).method_6643()) {
            return class_1269.field_5811;
        }
        if (!(snowGolem instanceof IUpgradeAbleSnowGolem)) {
            return class_1269.field_5811;
        }
        IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)snowGolem;
        if (stack.method_31574(class_1802.field_8179) || stack.method_31574(class_1802.field_8071)) {
            class_1799 oldItem = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.FACE);
            if (!oldItem.method_7960()) {
                player.method_7328(oldItem, true);
            }
            class_1799 newStack = stack.method_7972();
            newStack.method_7939(1);
            upgradeAbleSnowGolem.setGolemUpgradeInSlot(GolemUpgradeSlot.FACE, newStack);
            stack.method_7934(1);
            return class_1269.method_29236((boolean)player.method_37908().field_9236);
        }
        if (stack.method_7960() && player.method_5715()) {
            for (GolemUpgradeSlot value : GolemUpgradeSlot.values()) {
                class_1799 oldStack = upgradeAbleSnowGolem.setGolemUpgradeInSlot(value, class_1799.field_8037);
                if (oldStack.method_7960()) continue;
                player.method_7328(oldStack, true);
            }
            return class_1269.method_29236((boolean)player.method_37908().field_9236);
        }
        return class_1269.field_5811;
    }

    public void onEntitySpawn(class_1309 entity, class_4538 level) {
        class_6880 biome;
        if (!(entity instanceof class_1308)) {
            return;
        }
        class_1308 mob = (class_1308)entity;
        class_1299 type = mob.method_5864();
        boolean isSkeleton = type.equals(class_1299.field_6137) || type.equals(class_1299.field_6098);
        boolean isZombie = type.equals(class_1299.field_6051);
        if ((isSkeleton || isZombie) && !mob.method_6109() && (biome = level.method_22385().method_22393(entity.method_24515())).method_40227() && ((class_1959)biome.comp_349()).method_48163() && ((class_1959)biome.comp_349()).method_48162(entity.method_24515()).equals((Object)class_1959.class_1963.field_9383) && mob.method_6051().method_43057() > 0.9f && mob.method_6051().method_43057() > 0.5f) {
            class_1792 item = WinterOverhaul.getRandomHatAndScarf(mob.method_6051().method_43048(8));
            mob.method_5673(class_1304.field_6169, new class_1799((class_1935)item));
        }
    }

    public void addSpawns(BiomeSpawns spawns) {
        spawns.addSpawn(biome -> biome.method_40220(class_6908.field_36515) && ((class_1959)biome.comp_349()).method_8712() < 0.15f, class_1311.field_6294, new class_5483.class_1964((class_1299)ModEntities.ROBIN.get(), 25, 1, 2));
    }

    public void onMobDrops(class_1309 livingEntity, Collection<class_1542> drops) {
        if (livingEntity instanceof IUpgradeAbleSnowGolem) {
            IUpgradeAbleSnowGolem golem = (IUpgradeAbleSnowGolem)livingEntity;
            for (GolemUpgradeSlot value : GolemUpgradeSlot.values()) {
                class_1799 stack = golem.getGolemUpgradeInSlot(value);
                class_2338 pos = livingEntity.method_24515();
                if (stack.method_7960()) continue;
                drops.add(new class_1542(livingEntity.method_37908(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack.method_7972()));
            }
        }
    }

    public boolean onEntityDamage(class_1297 entity, class_1282 source) {
        return entity instanceof class_1473 && source.method_5526() instanceof class_1680;
    }

    public void addAttributes(EntityAttributesBuilder builder) {
        builder.register((class_1299<? extends class_1309>)((class_1299)ModEntities.ROBIN.get()), Robin.createAttributes().method_26866());
    }

    public void onComplete() {
        class_5620.field_27776.put((class_1792)ModItems.SKATES.get(), class_5620.field_27782);
    }

    private static class_1792 getRandomHatAndScarf(int randomInt) {
        return switch (randomInt) {
            case 0 -> (class_1792)ModItems.GREEN_HAT.get();
            case 1 -> (class_1792)ModItems.GREEN_SCARF.get();
            case 2 -> (class_1792)ModItems.YELLOW_HAT.get();
            case 3 -> (class_1792)ModItems.YELLOW_SCARF.get();
            case 4 -> (class_1792)ModItems.RED_HAT.get();
            case 5 -> (class_1792)ModItems.RED_SCARF.get();
            case 6 -> (class_1792)ModItems.CYAN_HAT.get();
            default -> (class_1792)ModItems.CYAN_SCARF.get();
        };
    }

    public static class_2960 id(String path) {
        return new class_2960(MODID, path);
    }
}

