/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.entity.Robin;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.registry.ModEntities;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;
import tech.thatgravyboat.winteroverhaul.common.registry.ModParticles;
import tech.thatgravyboat.winteroverhaul.common.registry.ModSounds;

@Mod(value="winteroverhaul")
public class WinterOverhaul {
    public static final String MODID = "winteroverhaul";
    public static final Logger LOGGER = LogManager.getLogger();

    public WinterOverhaul() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(modEventBus);
        ModParticles.PARTICLES.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        modEventBus.addListener(this::addAttributes);
        modEventBus.addListener(this::onComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nullable
    public static InteractionResult onEntityRightClick(Entity target, Vec3 loc, ItemStack stack, Player player) {
        SnowGolem snowGolem;
        if (!(target instanceof SnowGolem) || (snowGolem = (SnowGolem)target).m_29930_()) {
            return null;
        }
        if (!(snowGolem instanceof IUpgradeAbleSnowGolem)) {
            return null;
        }
        IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)snowGolem;
        if (stack.m_150930_(Items.f_42619_) || stack.m_150930_(Items.f_42677_)) {
            ItemStack oldItem = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.FACE);
            if (!oldItem.m_41619_()) {
                player.m_36176_(oldItem, true);
            }
            ItemStack newStack = stack.m_41777_();
            newStack.m_41764_(1);
            upgradeAbleSnowGolem.setGolemUpgradeInSlot(GolemUpgradeSlot.FACE, newStack);
            stack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        if (stack.m_41619_() && player.m_6144_()) {
            double y = loc.f_82480_;
            ItemStack oldStack = ItemStack.f_41583_;
            if (y >= 1.75) {
                oldStack = upgradeAbleSnowGolem.setGolemUpgradeInSlot(GolemUpgradeSlot.HAT, ItemStack.f_41583_);
            } else if (y >= 1.5) {
                oldStack = upgradeAbleSnowGolem.setGolemUpgradeInSlot(GolemUpgradeSlot.FACE, ItemStack.f_41583_);
            } else if (y >= 1.35) {
                oldStack = upgradeAbleSnowGolem.setGolemUpgradeInSlot(GolemUpgradeSlot.SCARF, ItemStack.f_41583_);
            }
            if (!oldStack.m_41619_()) {
                target.m_19983_(oldStack);
                return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onEntitySpawn(LivingSpawnEvent.CheckSpawn event) {
        Holder biome;
        Mob mob = event.getEntity();
        EntityType type = mob.m_6095_();
        if ((type.m_204039_(EntityTypeTags.f_13120_) || type.equals(EntityType.f_20501_)) && (biome = event.getLevel().m_7062_().m_204214_(event.getEntity().m_20183_())).m_203633_() && ((Biome)biome.m_203334_()).m_47530_().equals((Object)Biome.Precipitation.SNOW) && mob.m_217043_().m_188501_() > 0.9f && mob.m_217043_().m_188501_() > 0.5f) {
            Item item = WinterOverhaul.getRandomHatAndScarf(mob.m_217043_().m_188503_(8));
            mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)item));
        }
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof IUpgradeAbleSnowGolem) {
            IUpgradeAbleSnowGolem golem = (IUpgradeAbleSnowGolem)livingEntity;
            for (GolemUpgradeSlot value : GolemUpgradeSlot.values()) {
                ItemStack stack = golem.getGolemUpgradeInSlot(value);
                BlockPos pos = livingEntity.m_20183_();
                if (stack.m_41619_()) continue;
                event.getDrops().add(new ItemEntity(livingEntity.f_19853_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack.m_41777_()));
            }
        }
    }

    public void addAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.ROBIN.get(), Robin.createAttributes().m_22265_());
    }

    public void onComplete(FMLLoadCompleteEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.ROBIN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (entity, level, spawn, pos, random) -> {
            BlockState state = level.m_8055_(pos.m_7495_());
            boolean isLeaves = state.m_204336_(BlockTags.f_13035_);
            boolean isSnow = state.m_204336_(BlockTags.f_144279_);
            boolean isGrass = state.m_60713_(Blocks.f_50440_);
            return (isLeaves || isSnow || isGrass || state.m_60795_()) && level.m_45524_(pos, 0) > 8;
        });
        CauldronInteraction.f_175607_.put((Item)ModItems.SKATES.get(), CauldronInteraction.f_175615_);
    }

    private static Item getRandomHatAndScarf(int randomInt) {
        return switch (randomInt) {
            case 0 -> (Item)ModItems.GREEN_HAT.get();
            case 1 -> (Item)ModItems.GREEN_SCARF.get();
            case 2 -> (Item)ModItems.YELLOW_HAT.get();
            case 3 -> (Item)ModItems.YELLOW_SCARF.get();
            case 4 -> (Item)ModItems.RED_HAT.get();
            case 5 -> (Item)ModItems.RED_SCARF.get();
            case 6 -> (Item)ModItems.CYAN_HAT.get();
            default -> (Item)ModItems.CYAN_SCARF.get();
        };
    }
}

