/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.renderers.geo.GeoReplacedEntityRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.RenderUtils;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers.RandomArmLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers.RandomButtonLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers.RandomFaceLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers.UpgradeLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.model.ReplacedSnowGolemModel;
import tech.thatgravyboat.winteroverhaul.common.entity.ReplacedSnowGolem;

public class ReplacedSnowGolemRenderer
extends GeoReplacedEntityRenderer<ReplacedSnowGolem> {
    private boolean hasPumpkin = false;
    private MultiBufferSource source;

    public ReplacedSnowGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new ReplacedSnowGolemModel(), (IAnimatable)new ReplacedSnowGolem());
        this.addLayer(new RandomButtonLayer((IGeoRenderer)this));
        this.addLayer(new RandomFaceLayer((IGeoRenderer)this));
        this.addLayer(new RandomArmLayer((IGeoRenderer)this));
        this.addLayer(new UpgradeLayer((IGeoRenderer)this));
    }

    public void renderEarly(Object animatable, PoseStack stackIn, float partialTicks, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        SnowGolem golem;
        this.hasPumpkin = animatable instanceof SnowGolem && (golem = (SnowGolem)animatable).m_29930_();
        this.source = renderTypeBuffer;
        super.renderEarly(animatable, stackIn, partialTicks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("head") && this.hasPumpkin && this.source != null) {
            stack.m_85836_();
            RenderUtils.translate((GeoBone)bone, (PoseStack)stack);
            RenderUtils.moveToPivot((GeoBone)bone, (PoseStack)stack);
            RenderUtils.rotate((GeoBone)bone, (PoseStack)stack);
            RenderUtils.scale((GeoBone)bone, (PoseStack)stack);
            RenderUtils.moveBackFromPivot((GeoBone)bone, (PoseStack)stack);
            stack.m_85837_(0.0, 1.6, 0.0);
            stack.m_85841_(0.58f, 0.58f, 0.58f);
            Minecraft.m_91087_().m_91291_().m_174269_(new ItemStack((ItemLike)Blocks.f_50143_), ItemTransforms.TransformType.HEAD, packedLightIn, packedOverlayIn, stack, this.source, 0);
            stack.m_85849_();
            bufferIn = this.source.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_5478_(null)));
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public RenderType getRenderType(Object animatable, float partialTicks, PoseStack stack, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)textureLocation);
    }
}

