/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;

public class UpgradeLayer
extends GeoLayerRenderer {
    public UpgradeLayer(IGeoRenderer entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int packedLightIn, Entity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_20145_()) {
            return;
        }
        if (entity instanceof IUpgradeAbleSnowGolem) {
            IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)entity;
            GeoModel normalModel = this.getEntityModel().getModel(this.getEntityModel().getModelResource(null));
            ItemStack scarf = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.SCARF);
            UpgradeLayer.getTexture(scarf).ifPresent(texture -> this.getRenderer().render(normalModel, (Object)entity, partialTicks, null, stack, null, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture)), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f));
            ItemStack face = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.FACE);
            UpgradeLayer.getTexture(face).ifPresent(texture -> this.getRenderer().render(normalModel, (Object)entity, partialTicks, null, stack, null, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture)), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f));
            ItemStack hat = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.HAT);
            UpgradeLayer.getTexture(hat).ifPresent(texture -> this.getRenderer().render(normalModel, (Object)entity, partialTicks, null, stack, null, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture)), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f));
        }
    }

    private static Optional<ResourceLocation> getTexture(ItemStack item) {
        if (item.m_41619_()) {
            return Optional.empty();
        }
        ResourceLocation itemPath = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
        if (itemPath == null) {
            return Optional.empty();
        }
        return Optional.of(new ResourceLocation("winteroverhaul", "textures/entity/upgrades/" + itemPath.m_135815_() + ".png"));
    }
}

