/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity.model;

import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import tech.thatgravyboat.winteroverhaul.common.entity.ReplacedSnowGolem;

public class ReplacedSnowGolemModel<E extends ReplacedSnowGolem>
extends AnimatedGeoModel<E> {
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("winteroverhaul", "textures/entity/snow_golem.png");
    private static final ResourceLocation MODEL = new ResourceLocation("winteroverhaul", "geo/snow_golem.geo.json");
    private static final ResourceLocation ANIMATION = new ResourceLocation("winteroverhaul", "animations/snow_golem.animation.json");

    public ResourceLocation getModelResource(E object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(E object) {
        return BASE_TEXTURE;
    }

    public ResourceLocation getAnimationResource(E animatable) {
        return ANIMATION;
    }

    public void setLivingAnimations(E entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations(entity, uniqueID, customPredicate);
        if (customPredicate == null) {
            return;
        }
        EntityModelData extraData = (EntityModelData)ReplacedSnowGolemModel.getExtraData(customPredicate);
        IBone head = this.getAnimationProcessor().getBone("head");
        head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
        IBone upperBody = this.getAnimationProcessor().getBone("body_2");
        upperBody.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180) * 0.25f);
    }

    private static <T> T getExtraData(AnimationEvent customPredicate) {
        return (T)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
    }
}

