/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.winteroverhaul.common.registry.ModEntities;
import tech.thatgravyboat.winteroverhaul.common.registry.ModSounds;

public class Robin
extends Animal
implements FlyingAnimal,
IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;

    public Robin(EntityType<? extends Animal> entity, Level level) {
        super(entity, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_8107_() {
        super.m_8107_();
        this.calculateFlapping();
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.f_19861_ && !this.m_20159_() ? 4 : -1) * 0.3);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vec3 = this.m_20184_();
        if (!this.f_19861_ && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.m_5496_(SoundEvents.f_12191_, 0.15f, 1.0f);
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource source) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public boolean m_7327_(Entity pEntity) {
        return pEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 3.0f);
    }

    @Nullable
    public SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ROBIN_AMBIENT.get();
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42780_);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return (AgeableMob)((EntityType)ModEntities.ROBIN.get()).m_20615_((Level)level);
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    private <E extends IAnimatable> PlayState idle(AnimationEvent<E> event) {
        boolean fiveCheck;
        boolean isRunning;
        boolean bl = isRunning = !event.getController().getAnimationState().equals((Object)AnimationState.Stopped);
        if (this.m_29443_()) {
            event.getController().markNeedsReload();
            return PlayState.STOP;
        }
        if (isRunning) {
            return PlayState.CONTINUE;
        }
        boolean threeCheck = this.f_19797_ % 60 == 0 && this.f_19796_.m_188499_();
        boolean fourCheck = this.f_19797_ % 80 == 0 && this.f_19796_.m_188499_();
        boolean bl2 = fiveCheck = this.f_19797_ % 100 == 0;
        if (threeCheck || fourCheck || fiveCheck) {
            switch (this.f_19796_.m_188503_(3)) {
                case 0: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.robin.idle1", Boolean.valueOf(false)));
                    return PlayState.CONTINUE;
                }
                case 1: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.robin.idle2", Boolean.valueOf(false)));
                    return PlayState.CONTINUE;
                }
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.robin.idle3", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState flying(AnimationEvent<E> event) {
        if (this.m_29443_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.robin.fly", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "flight_controller", 0.0f, this::flying));
        data.addAnimationController(new AnimationController((IAnimatable)this, "idle_controller", 5.0f, this::idle));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

