/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;
import tech.thatgravyboat.winteroverhaul.WinterOverhaul;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeArmorMaterial;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;

public class GolemUpgradeItem
extends GeoArmorItem
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final GolemUpgradeSlot slot;

    public GolemUpgradeItem(GolemUpgradeSlot slot, Item.Properties pProperties) {
        super((ArmorMaterial)GolemUpgradeArmorMaterial.INSTANCE, EquipmentSlot.HEAD, pProperties.m_41487_(1));
        this.slot = slot;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)itemstack);
        ItemStack itemstack1 = pPlayer.m_6844_(equipmentslot);
        if (itemstack1.m_41619_()) {
            pPlayer.m_8061_(equipmentslot, itemstack.m_41777_());
            if (!pLevel.m_5776_()) {
                pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            itemstack.m_41764_(0);
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        SnowGolem snowGolem;
        if (!(target instanceof SnowGolem) || (snowGolem = (SnowGolem)target).m_29930_()) {
            return super.m_6880_(stack, player, target, hand);
        }
        if (!(snowGolem instanceof IUpgradeAbleSnowGolem)) {
            WinterOverhaul.LOGGER.error("Snow Golem was not an instance of IUpgradeAbleSnowGolem so mixin error occurred!");
            return super.m_6880_(stack, player, target, hand);
        }
        IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)snowGolem;
        ItemStack oldHat = upgradeAbleSnowGolem.getGolemUpgradeInSlot(this.slot);
        if (!oldHat.m_41619_()) {
            player.m_36176_(oldHat, true);
        }
        upgradeAbleSnowGolem.setGolemUpgradeInSlot(this.slot, stack.m_41777_());
        stack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public void tick(ItemStack stack, SnowGolem golem) {
        MobEffectInstance effectInstance;
        Item item = stack.m_41720_();
        if (!golem.m_21023_(MobEffects.f_19607_) && (item.equals(ModItems.YELLOW_SCARF.get()) || item.equals(ModItems.YELLOW_HAT.get()))) {
            golem.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 20, 0, false, false));
        }
        if (item.equals(ModItems.TOP_HAT.get()) && golem.f_19797_ % 20 == 0) {
            golem.m_5634_(0.5f);
        }
        if (item.equals(ModItems.TOP_HAT.get()) && ((effectInstance = golem.m_21124_(MobEffects.f_19616_)) == null || golem.f_19797_ % 5 == 0)) {
            MobEffectInstance healthBoost = new MobEffectInstance(MobEffects.f_19616_, 20, 0, false, false);
            if (effectInstance == null) {
                golem.m_7292_(healthBoost);
            } else {
                effectInstance.m_19558_(healthBoost);
            }
        }
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level pLevel, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"item.winteroverhaul.upgrade.header").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)this.getDesc().m_130940_(ChatFormatting.BLUE));
    }

    public MutableComponent getDesc() {
        return Component.m_237115_((String)(this.m_5524_() + ".desc"));
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        return ImmutableMultimap.of();
    }
}

