/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.common.items;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;

public class SkateItem
extends ArmorItem
implements IAnimatable,
DyeableLeatherItem {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public SkateItem(Item.Properties builder) {
        super((ArmorMaterial)ArmorMaterials.LEATHER, EquipmentSlot.FEET, builder);
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return GeoArmorRenderer.getRenderer(((Object)((Object)SkateItem.this)).getClass(), (Entity)livingEntity).applyEntityStats(original).applySlot(equipmentSlot).setCurrentItem(livingEntity, itemStack, equipmentSlot);
            }
        });
    }

    public final String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ResourceLocation normal = new ResourceLocation("winteroverhaul", "textures/entity/skates/base.png");
        ResourceLocation overlay = new ResourceLocation("winteroverhaul", "textures/entity/skates/overlay.png");
        return Objects.equals(type, "overlay") ? overlay.toString() : normal.toString();
    }
}

