/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tech.thatgravyboat.winteroverhaul.common.items.SkateItem;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    public MixinLivingEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity;
        boolean isWearingBoots;
        BlockState state = this.f_19853_.m_8055_(this.m_20099_());
        boolean isIce = state.m_60713_(Blocks.f_50126_) || state.m_60713_(Blocks.f_50568_) || state.m_60713_(Blocks.f_50354_);
        MixinLivingEntity mixinLivingEntity = this;
        boolean bl = isWearingBoots = mixinLivingEntity instanceof LivingEntity && (livingEntity = (LivingEntity)mixinLivingEntity).m_6844_(EquipmentSlot.FEET).m_41720_() instanceof SkateItem;
        if (isIce && isWearingBoots) {
            cir.setReturnValue((Object)Float.valueOf(1.05f));
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFriction(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)F"))
    private float onGetFriction(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        LivingEntity livingEntity;
        if (state.m_204336_(BlockTags.f_13047_) && !entity.m_20142_() && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6844_(EquipmentSlot.FEET).m_41720_() instanceof SkateItem) {
            return 0.8f;
        }
        return state.getFriction(level, pos, entity);
    }
}

