/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.mixin;

import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import tech.thatgravyboat.winteroverhaul.common.entity.GolemAttackableTargetGoal;
import tech.thatgravyboat.winteroverhaul.common.entity.GolemRangedAttackGoal;
import tech.thatgravyboat.winteroverhaul.common.entity.ISnowGolemSnowball;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeItem;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;
import tech.thatgravyboat.winteroverhaul.common.registry.ModParticles;

@Mixin(value={SnowGolem.class})
public abstract class MixinSnowGolem
extends Mob
implements IUpgradeAbleSnowGolem,
IEntityAdditionalSpawnData {
    @Unique
    private final NonNullList<ItemStack> upgrades = NonNullList.m_122780_((int)GolemUpgradeSlot.values().length, (Object)ItemStack.f_41583_);

    protected MixinSnowGolem(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void onAiStep(CallbackInfo ci) {
        SnowGolem golem = (SnowGolem)this;
        if (!golem.f_19853_.f_46443_) {
            if (this.upgrades != null) {
                this.upgrades.forEach(stack -> {
                    Item patt2901$temp = stack.m_41720_();
                    if (patt2901$temp instanceof GolemUpgradeItem) {
                        GolemUpgradeItem upgradeItem = (GolemUpgradeItem)patt2901$temp;
                        upgradeItem.tick((ItemStack)stack, golem);
                    }
                });
            }
        } else if (this.f_19797_ % 2 == 0) {
            float health = golem.m_21223_() / golem.m_21233_();
            SimpleParticleType particleType = health >= 0.6f ? (SimpleParticleType)ModParticles.SNOWFAKE_1.get() : ((double)health >= 0.3 ? (SimpleParticleType)ModParticles.SNOWFAKE_2.get() : (SimpleParticleType)ModParticles.SNOWFAKE_3.get());
            this.f_19853_.m_7106_((ParticleOptions)particleType, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void changeRangeAttackGoal(CallbackInfo ci) {
        SnowGolem golem = (SnowGolem)this;
        golem.f_21345_.m_148105_().removeIf(goal -> goal.m_26015_() instanceof RangedAttackGoal);
        golem.f_21345_.m_25352_(1, (Goal)new GolemRangedAttackGoal(golem, 1.25, 20, 10.0f));
        golem.f_21346_.m_148105_().removeIf(goal -> goal.m_26015_() instanceof NearestAttackableTargetGoal);
        golem.f_21346_.m_25352_(1, new GolemAttackableTargetGoal<Mob>(this, Mob.class, 10, true, false, entity -> entity instanceof Enemy));
    }

    @Inject(method={"performRangedAttack"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getEyeY()D")})
    private void onSnowballCreation(LivingEntity pTarget, float pDistanceFactor, CallbackInfo ci, Snowball snowball) {
        if (snowball instanceof ISnowGolemSnowball) {
            Item face;
            ISnowGolemSnowball snowGolemSnowball = (ISnowGolemSnowball)snowball;
            snowGolemSnowball.winteroverhaul_setGolemSnowball(true);
            Item scraf = this.getGolemUpgradeInSlot(GolemUpgradeSlot.SCARF).m_41720_();
            Item hat = this.getGolemUpgradeInSlot(GolemUpgradeSlot.HAT).m_41720_();
            int amount = hat.equals(ModItems.RED_HAT.get()) ? 2 : 0;
            if ((amount += scraf.equals(ModItems.RED_SCARF.get()) ? 2 : 0) > 0) {
                snowGolemSnowball.winteroverhaul_setGolemMultiplier(amount);
            }
            if ((face = this.getGolemUpgradeInSlot(GolemUpgradeSlot.FACE).m_41720_()).equals(Items.f_42619_) || face.equals(Items.f_42677_)) {
                snowGolemSnowball.winteroverhaul_addMobEffect(new MobEffectInstance(MobEffects.f_19597_, 20, 1));
                if (face.equals(Items.f_42677_)) {
                    snowGolemSnowball.winteroverhaul_addMobEffect(new MobEffectInstance(MobEffects.f_19613_, 20, 4));
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onSaveNbt(CompoundTag pCompound, CallbackInfo ci) {
        ListTag listtag = new ListTag();
        if (this.upgrades != null) {
            for (ItemStack itemstack : this.upgrades) {
                CompoundTag compoundtag = new CompoundTag();
                if (!itemstack.m_41619_()) {
                    itemstack.m_41739_(compoundtag);
                }
                listtag.add((Object)compoundtag);
            }
        }
        pCompound.m_128365_("GolemUpgrades", (Tag)listtag);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onLoadNbt(CompoundTag pCompound, CallbackInfo ci) {
        if (pCompound.m_128425_("GolemUpgrades", 9)) {
            ListTag listtag = pCompound.m_128437_("GolemUpgrades", 10);
            if (this.upgrades != null) {
                for (int i = 0; i < this.upgrades.size(); ++i) {
                    CompoundTag itemTag = listtag.m_128728_(i);
                    if (itemTag.m_128456_()) continue;
                    this.upgrades.set(i, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
                }
            }
        }
    }

    @Override
    public ItemStack setGolemUpgradeInSlot(GolemUpgradeSlot slot, ItemStack stack) {
        if (this.upgrades == null) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.upgrades.set(slot.index, (Object)stack);
    }

    @Override
    public ItemStack getGolemUpgradeInSlot(GolemUpgradeSlot slot) {
        if (this.upgrades == null) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.upgrades.get(slot.index);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.upgrades.size());
        for (ItemStack upgrade : this.upgrades) {
            buffer.m_130055_(upgrade.m_41777_());
        }
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        IntStream.range(0, buffer.readInt()).forEach(i -> this.upgrades.set(i, (Object)buffer.m_130267_()));
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

