/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.mixin;

import com.leclowndu93150.particular.CommonClass;
import com.leclowndu93150.particular.ParticularConfig;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LeavesBlock.class})
public class InjectLeavesBlock {
    @Inject(method={"animateTick"}, at={@At(value="HEAD")})
    private void dropLeaves(BlockState state, Level world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        BlockPos blockPos;
        BlockState blockState;
        if (!ParticularConfig.fallingLeaves()) {
            return;
        }
        if (random.nextInt(((Integer)ParticularConfig.COMMON.fallingLeavesSpawnChance.get()).intValue()) == 0 && !Block.isFaceFull((VoxelShape)(blockState = world.getBlockState(blockPos = pos.below())).getCollisionShape((BlockGetter)world, blockPos), (Direction)Direction.UP)) {
            double x = (double)pos.getX() + 0.02 + random.nextDouble() * 0.96;
            double y = (double)pos.getY() - 0.05;
            double z = (double)pos.getZ() + 0.02 + random.nextDouble() * 0.96;
            CommonClass.LeafData leafData = CommonClass.getLeafData(state.getBlock());
            ParticleOptions particle = leafData.getParticle();
            if (particle == null) {
                return;
            }
            Color color = leafData.getColor(world, pos);
            Particle leaf = Minecraft.getInstance().particleEngine.createParticle(particle, x, y, z, 0.0, 0.0, 0.0);
            if (leaf != null) {
                leaf.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
        }
    }
}

