/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles.leaves;

import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class LeafParticle
extends TextureSheetParticle {
    protected static final int fadeInDuration = 10;
    protected static final int rampUpDuration = 20;
    protected static final int fadeOutDuration = 100;
    protected float rotateFactor;
    protected float gravityFactor = 0.075f;
    protected final boolean flippedSprite;
    protected final int flippedDirection;
    protected boolean expiring = false;

    protected LeafParticle(ClientLevel world, double x, double y, double z, double r, double g, double b, SpriteSet provider) {
        super(world, x, y, z, r, g, b);
        this.pickSprite(provider);
        this.hasPhysics = true;
        this.gravity = 0.0f;
        this.lifetime = 200;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.alpha = 0.0f;
        this.rCol = (float)r;
        this.gCol = (float)g;
        this.bCol = (float)b;
        this.rotateFactor = 6.0f + (float)Math.random() * 3.0f;
        this.flippedSprite = this.random.nextBoolean();
        this.flippedDirection = this.random.nextBoolean() ? 1 : -1;
        this.quadSize = 0.21875f;
    }

    protected float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    protected float getAngle() {
        int time = this.age - 10;
        float speed = this.rotateFactor;
        float amplitude = this.clamp(time, 0.0f, 30.0f) / 30.0f;
        return (float)Math.sin((float)time / speed) * amplitude * 0.5f * (float)this.flippedDirection;
    }

    public void tick() {
        super.tick();
        if (this.age <= 10) {
            this.yd = 0.0;
        } else if (!this.expiring && (this.onGround || this.yd == 0.0)) {
            this.expiring = true;
            this.age = this.lifetime - 100;
            this.y += 0.01;
            if (((Boolean)ParticularConfig.COMMON.fallingLeavesLayFlatOnGround.get()).booleanValue()) {
                this.roll = (Boolean)ParticularConfig.COMMON.fallingLeavesLayFlatRightAngles.get() != false ? (float)((double)this.random.nextInt(4) / 2.0 * Math.PI) : (float)(Math.random() * Math.PI * 2.0);
            }
        }
        this.oRoll = this.roll;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        FluidState fluidState = this.level.getFluidState(pos);
        if (fluidState.is(FluidTags.WATER)) {
            if (this.gravity > 0.0f) {
                this.y = (float)pos.getY() + fluidState.getHeight((BlockGetter)this.level, pos);
                if (((Boolean)ParticularConfig.COMMON.fallingLeavesSpawnRipples.get()).booleanValue()) {
                    this.level.addParticle((ParticleOptions)Particles.WATER_RIPPLE.get(), this.x, this.y, this.z, 0.0, 0.0, 0.0);
                }
            }
            this.yd = 0.0;
            this.gravity = 0.0f;
        } else if (this.age >= 10) {
            this.gravity = this.gravityFactor;
            if (!this.onGround) {
                this.roll = this.getAngle();
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vector3f[] vector3fs;
        Vec3 vec3d = camera.getPosition();
        float f = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - vec3d.x());
        float g = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - vec3d.y());
        float h = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - vec3d.z());
        float j = this.getQuadSize(tickDelta);
        if (!this.expiring || !((Boolean)ParticularConfig.COMMON.fallingLeavesLayFlatOnGround.get()).booleanValue()) {
            Quaternionf quaternionf;
            vector3fs = new Vector3f[]{new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
            if (this.roll == 0.0f) {
                quaternionf = camera.rotation();
            } else {
                quaternionf = new Quaternionf((Quaternionfc)camera.rotation());
                quaternionf.rotateZ(Mth.lerp((float)tickDelta, (float)this.oRoll, (float)this.roll));
            }
            for (int k = 0; k < 4; ++k) {
                Vector3f vector3f = vector3fs[k];
                vector3f.rotate((Quaternionfc)quaternionf);
                vector3f.mul(j);
                vector3f.add(f, g, h);
            }
        } else {
            vector3fs = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
            for (int k = 0; k < 4; ++k) {
                Vector3f vector3f = vector3fs[k];
                vector3f.rotateAxis(this.roll, 0.0f, 1.0f, 0.0f);
                vector3f.mul(j);
                vector3f.add(f, g, h);
            }
        }
        float ageDelta = Mth.lerpInt((float)tickDelta, (int)this.age, (int)(this.age + 1));
        this.alpha = this.age <= 10 ? ageDelta / 10.0f : (this.age > this.lifetime - 100 ? Math.max(0.0f, ((float)this.lifetime - ageDelta) / 100.0f) : 1.0f);
        float l = this.getU0();
        float m = this.getU1();
        float n = this.getV0();
        float o = this.getV1();
        int p = this.getLightColor(tickDelta);
        if (this.flippedSprite) {
            float temp = l;
            l = m;
            m = temp;
        }
        vertexConsumer.addVertex(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).setUv(m, o).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(p);
        vertexConsumer.addVertex(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).setUv(m, n).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(p);
        vertexConsumer.addVertex(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).setUv(l, n).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(p);
        vertexConsumer.addVertex(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).setUv(l, o).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(p);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            return new LeafParticle(world, x, y, z, velX, velY, velZ, this.provider);
        }
    }
}

