/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular;

import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import com.leclowndu93150.particular.compat.RegionsUnexplored;
import com.leclowndu93150.particular.compat.Traverse;
import com.leclowndu93150.particular.compat.WilderWild;
import com.leclowndu93150.particular.mixin.AccessorBiome;
import com.leclowndu93150.particular.utils.CascadeData;
import com.leclowndu93150.particular.utils.LeafColorUtil;
import com.leclowndu93150.particular.utils.TextureCache;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="particular")
public class Main {
    public static final String MOD_ID = "particular";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"particular");
    public static ResourceLocation currentDimension;
    public static ConcurrentHashMap<BlockPos, CascadeData> cascades;
    private static float fireflyFrequency;
    private static Map<Block, LeafData> leavesData;

    public Main(IEventBus modEventBus, ModContainer modContainer) {
        LOGGER.info("I am quite particular about the effects I choose to add :3");
        ParticularConfig.register(modContainer);
        Particles.register(modEventBus);
        if (FMLLoader.getDist().isClient()) {
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(Particles::registerFactories);
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        leavesData.put(Blocks.OAK_LEAVES, new LeafData((ParticleOptions)Particles.OAK_LEAF.get()));
        leavesData.put(Blocks.BIRCH_LEAVES, new LeafData((ParticleOptions)Particles.BIRCH_LEAF.get(), new Color(FoliageColor.getBirchColor())));
        leavesData.put(Blocks.SPRUCE_LEAVES, new LeafData((ParticleOptions)Particles.SPRUCE_LEAF.get(), new Color(FoliageColor.getEvergreenColor())));
        leavesData.put(Blocks.JUNGLE_LEAVES, new LeafData((ParticleOptions)Particles.JUNGLE_LEAF.get()));
        leavesData.put(Blocks.ACACIA_LEAVES, new LeafData((ParticleOptions)Particles.ACACIA_LEAF.get()));
        leavesData.put(Blocks.DARK_OAK_LEAVES, new LeafData((ParticleOptions)Particles.DARK_OAK_LEAF.get()));
        leavesData.put(Blocks.AZALEA_LEAVES, new LeafData((ParticleOptions)Particles.AZALEA_LEAF.get(), Color.white));
        leavesData.put(Blocks.FLOWERING_AZALEA_LEAVES, new LeafData((ParticleOptions)Particles.AZALEA_LEAF.get(), Color.white));
        leavesData.put(Blocks.MANGROVE_LEAVES, new LeafData((ParticleOptions)Particles.MANGROVE_LEAF.get()));
        leavesData.put(Blocks.CHERRY_LEAVES, new LeafData(null));
        if (ModList.get().isLoaded("traverse")) {
            Traverse.addLeaves();
        }
        if (ModList.get().isLoaded("regions_unexplored")) {
            RegionsUnexplored.addLeaves();
        }
        if (ModList.get().isLoaded("wilderwild")) {
            WilderWild.addLeaves();
        }
        event.enqueueWork(() -> {
            for (Block block : BuiltInRegistries.BLOCK) {
                boolean isLeafBlock;
                ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
                if (leavesData.containsKey(block) || !(isLeafBlock = block instanceof LeavesBlock || id.getPath().contains("leaves") || id.getPath().contains("leaf"))) continue;
                ParticleOptions particle = (ParticleOptions)Particles.OAK_LEAF.get();
                if (id.getPath().contains("spruce") || id.getPath().contains("pine") || id.getPath().contains("fir") || id.getPath().contains("conifer")) {
                    particle = (ParticleOptions)Particles.SPRUCE_LEAF.get();
                } else if (id.getPath().contains("birch")) {
                    particle = (ParticleOptions)Particles.BIRCH_LEAF.get();
                } else if (id.getPath().contains("jungle")) {
                    particle = (ParticleOptions)Particles.JUNGLE_LEAF.get();
                } else if (id.getPath().contains("acacia")) {
                    particle = (ParticleOptions)Particles.ACACIA_LEAF.get();
                } else if (id.getPath().contains("dark_oak")) {
                    particle = (ParticleOptions)Particles.DARK_OAK_LEAF.get();
                } else if (id.getPath().contains("mangrove")) {
                    particle = (ParticleOptions)Particles.MANGROVE_LEAF.get();
                }
                LeafData leafData = new LeafData(particle);
                leavesData.put(block, leafData);
            }
        });
    }

    @SubscribeEvent
    public static void onResourcesReloaded(TextureAtlasStitchedEvent event) {
        TextureCache.clear();
    }

    public static Color extractLeafColor(Level world, BlockPos pos, Block block) {
        BlockState state = block.defaultBlockState();
        try {
            if (world.getBlockState(pos).getBlock() == block) {
                state = world.getBlockState(pos);
            }
            double[] colorValues = LeafColorUtil.getBlockTextureColor(state, world, pos);
            return LeafColorUtil.getColorFromValues(colorValues);
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract leaf color", (Throwable)e);
            return new Color(BiomeColors.getAverageFoliageColor((BlockAndTintGetter)world, (BlockPos)pos));
        }
    }

    public static void registerLeafData(Block block, LeafData leafData) {
        leavesData.put(block, leafData);
    }

    public static void registerLeafData(ResourceLocation id, LeafData leafData) {
        BuiltInRegistries.BLOCK.getOptional(id).ifPresent(block -> leavesData.put((Block)block, leafData));
    }

    public static LeafData getLeafData(Block block) {
        return leavesData.getOrDefault(block, new LeafData((ParticleOptions)Particles.OAK_LEAF.get()));
    }

    public static void updateCascade(Level world, BlockPos pos, FluidState state) {
        boolean shouldHaveCascade;
        BlockPos immutablePos = pos.immutable();
        if (cascades.containsKey(immutablePos)) {
            return;
        }
        boolean bl = shouldHaveCascade = state.is((Fluid)Fluids.WATER) && world.getFluidState(pos.above()).is((Fluid)Fluids.FLOWING_WATER) && world.getFluidState(pos.below()).is((Fluid)Fluids.WATER);
        if (shouldHaveCascade) {
            int strength = 0;
            if (world.getFluidState(pos.north()).is((Fluid)Fluids.WATER)) {
                ++strength;
            }
            if (world.getFluidState(pos.east()).is((Fluid)Fluids.WATER)) {
                ++strength;
            }
            if (world.getFluidState(pos.south()).is((Fluid)Fluids.WATER)) {
                ++strength;
            }
            if (world.getFluidState(pos.west()).is((Fluid)Fluids.WATER)) {
                ++strength;
            }
            if (strength > 0) {
                boolean isEncased;
                boolean bl2 = isEncased = !world.getBlockState(pos.above().north()).isAir() && !world.getBlockState(pos.above().east()).isAir() && !world.getBlockState(pos.above().south()).isAir() && !world.getBlockState(pos.above().west()).isAir();
                if (!isEncased) {
                    cascades.put(immutablePos, new CascadeData(strength, world.getGameTime() - 101L));
                }
            }
        }
    }

    public static void spawnBubble(ParticleOptions particle, Level world, BlockPos pos) {
        double x = (double)pos.getX() + 0.25 + world.random.nextDouble() * 0.5;
        double y = (double)pos.getY() + 0.25 + world.random.nextDouble() * 0.5;
        double z = (double)pos.getZ() + 0.25 + world.random.nextDouble() * 0.5;
        world.addParticle(particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnFirefly(Level world, BlockPos pos, RandomSource random) {
        if (random.nextDouble() > (double)fireflyFrequency) {
            return;
        }
        Biome biome = (Biome)world.getBiome(pos).value();
        float downfall = ((AccessorBiome)biome).getWeather().downfall();
        if ((!world.isRaining() || ((Boolean)ParticularConfig.COMMON.fireflyCanSpawnInRain.get()).booleanValue()) && random.nextInt(30 - (int)(10.0f * downfall)) == 0) {
            long time = world.getDayTime();
            float temp = biome.getBaseTemperature();
            if (time >= (long)((Integer)ParticularConfig.COMMON.fireflyStartTime.get()).intValue() && time <= (long)((Integer)ParticularConfig.COMMON.fireflyEndTime.get()).intValue() && (double)temp >= (Double)ParticularConfig.COMMON.fireflyMinTemp.get() && (double)temp <= (Double)ParticularConfig.COMMON.fireflyMaxTemp.get()) {
                world.addParticle((ParticleOptions)Particles.FIREFLY.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnDoubleBubbles(ParticleOptions particle, Level world, BlockPos pos, BlockState state) {
        ChestType chestType = (ChestType)state.getValue((Property)BlockStateProperties.CHEST_TYPE);
        boolean xLen = false;
        boolean zLen = false;
        int xOffset = 0;
        int zOffset = 0;
        switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case NORTH: {
                xLen = true;
                if (chestType != ChestType.RIGHT) break;
                xOffset = -1;
                break;
            }
            case SOUTH: {
                xLen = true;
                if (chestType != ChestType.LEFT) break;
                xOffset = -1;
                break;
            }
            case EAST: {
                zLen = true;
                if (chestType != ChestType.RIGHT) break;
                zOffset = -1;
                break;
            }
            case WEST: {
                zLen = true;
                if (chestType != ChestType.LEFT) break;
                zOffset = -1;
            }
        }
        for (int i = 0; i < 2; ++i) {
            double x = (double)pos.getX() + 0.25 + world.random.nextDouble() * (0.5 + (double)xLen) + (double)xOffset;
            double y = (double)pos.getY() + 0.25 + world.random.nextDouble() * 0.5;
            double z = (double)pos.getZ() + 0.25 + world.random.nextDouble() * (0.5 + (double)zLen) + (double)zOffset;
            world.addParticle(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnChestBubbles(ParticleOptions particle, Level world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            Main.spawnBubble(particle, world, pos);
        }
    }

    public static void spawnDoubleChestBubbles(ParticleOptions particle, Level world, BlockPos pos, BlockState state) {
        ChestType chestType = (ChestType)state.getValue((Property)BlockStateProperties.CHEST_TYPE);
        boolean xLen = false;
        boolean zLen = false;
        int xOffset = 0;
        int zOffset = 0;
        switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case NORTH: {
                xLen = true;
                if (chestType != ChestType.RIGHT) break;
                xOffset = -1;
                break;
            }
            case SOUTH: {
                xLen = true;
                if (chestType != ChestType.LEFT) break;
                xOffset = -1;
                break;
            }
            case EAST: {
                zLen = true;
                if (chestType != ChestType.RIGHT) break;
                zOffset = -1;
                break;
            }
            case WEST: {
                zLen = true;
                if (chestType != ChestType.LEFT) break;
                zOffset = -1;
            }
        }
        for (int i = 0; i < 20; ++i) {
            double x = (double)pos.getX() + 0.25 + world.random.nextDouble() * (0.5 + (double)xLen) + (double)xOffset;
            double y = (double)pos.getY() + 0.25 + world.random.nextDouble() * 0.5;
            double z = (double)pos.getZ() + 0.25 + world.random.nextDouble() * (0.5 + (double)zLen) + (double)zOffset;
            world.addParticle(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static void cleanupInvalidCascades(Level world) {
        if (!ParticularConfig.cascades()) {
            cascades.clear();
            return;
        }
        long currentTime = world.getGameTime();
        cascades.entrySet().removeIf(entry -> {
            BlockPos pos = (BlockPos)entry.getKey();
            CascadeData cascadeData = (CascadeData)entry.getValue();
            if (!world.hasChunkAt(pos)) {
                return true;
            }
            if (currentTime - cascadeData.createdTime > 100L) {
                return true;
            }
            FluidState currentState = world.getFluidState(pos);
            FluidState aboveState = world.getFluidState(pos.above());
            FluidState belowState = world.getFluidState(pos.below());
            boolean isValid = currentState.is((Fluid)Fluids.WATER) && aboveState.is((Fluid)Fluids.FLOWING_WATER) && belowState.is((Fluid)Fluids.WATER);
            return !isValid;
        });
    }

    static {
        cascades = new ConcurrentHashMap();
        fireflyFrequency = 1.0f;
        leavesData = new HashMap<Block, LeafData>();
    }

    public static class LeafData {
        private final ParticleOptions particle;
        private final BiFunction<Level, BlockPos, Color> colorBiFunc;

        public LeafData(ParticleOptions particle, BiFunction<Level, BlockPos, Color> colorBiFunc) {
            this.particle = particle;
            this.colorBiFunc = colorBiFunc;
        }

        public LeafData(ParticleOptions particle, Color color) {
            this(particle, (Level world, BlockPos pos) -> color);
        }

        public LeafData(ParticleOptions particle) {
            this(particle, (Level world, BlockPos pos) -> {
                Block block = world.getBlockState(pos).getBlock();
                return Main.extractLeafColor(world, pos, block);
            });
        }

        public ParticleOptions getParticle() {
            return this.particle;
        }

        public Color getColor(Level world, BlockPos pos) {
            return this.colorBiFunc.apply(world, pos);
        }
    }

    @EventBusSubscriber(modid="particular", value={Dist.CLIENT})
    public static class ClientEvents {
        private static int cascadeCleanupTicks = 0;

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Pre event) {
            ClientLevel world = Minecraft.getInstance().level;
            if (world == null) {
                return;
            }
            RandomSource random = world.random;
            if (world.getDayTime() == (long)((Integer)ParticularConfig.COMMON.fireflyStartTime.get()).intValue()) {
                List dailyRandomList = (List)ParticularConfig.COMMON.fireflyDailyRandom.get();
                fireflyFrequency = ((Double)dailyRandomList.get(random.nextInt(dailyRandomList.size()))).floatValue();
            }
            if (!ParticularConfig.waterSplash()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            int renderDistance = (Integer)mc.options.renderDistance().get();
            BlockPos playerPos = mc.player.blockPosition();
            long currentTime = world.getGameTime();
            cascades.entrySet().removeIf(arg_0 -> ClientEvents.lambda$onClientTick$0(playerPos, renderDistance, currentTime, (Level)world, random, mc, arg_0));
            if (++cascadeCleanupTicks >= 100) {
                cascadeCleanupTicks = 0;
                Main.cleanupInvalidCascades((Level)world);
            }
        }

        @SubscribeEvent
        public static void onRenderHUD(RenderGuiEvent.Post event) {
            if (FMLLoader.isProduction()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null || mc.level == null) {
                return;
            }
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Font font = mc.font;
            String cascadeText = "Cascades: " + cascades.size();
            int textWidth = font.width(cascadeText);
            int x = 10;
            int y = 10;
            Objects.requireNonNull(font);
            guiGraphics.fill(x - 2, y - 2, x + textWidth + 2, y + 9 + 2, Integer.MIN_VALUE);
            guiGraphics.drawString(font, cascadeText, x, y, 0xFFFFFF);
        }

        @SubscribeEvent
        public static void onChunkLoad(ChunkEvent.Load event) {
            Level world = (Level)event.getLevel();
            if (!ParticularConfig.cascades() || !world.isClientSide()) {
                return;
            }
            ResourceLocation newDimension = world.dimensionType().effectsLocation();
            if (currentDimension != null && !newDimension.equals((Object)currentDimension)) {
                LOGGER.debug("Dimension changed from {} to {}, clearing cascades", (Object)currentDimension, (Object)newDimension);
                cascades.clear();
            }
            currentDimension = newDimension;
        }

        @SubscribeEvent
        public static void onChunkUnload(ChunkEvent.Unload event) {
            if (!ParticularConfig.cascades() || !event.getLevel().isClientSide()) {
                return;
            }
            ChunkPos chunkPos = event.getChunk().getPos();
            int minX = chunkPos.getMinBlockX();
            int maxX = chunkPos.getMaxBlockX();
            int minZ = chunkPos.getMinBlockZ();
            int maxZ = chunkPos.getMaxBlockZ();
            cascades.entrySet().removeIf(entry -> {
                BlockPos pos = (BlockPos)entry.getKey();
                return pos.getX() >= minX && pos.getX() <= maxX && pos.getZ() >= minZ && pos.getZ() <= maxZ;
            });
        }

        @SubscribeEvent
        public static void onLevelUnload(LevelEvent.Unload event) {
            if (event.getLevel().isClientSide()) {
                cascades.clear();
            }
        }

        private static /* synthetic */ boolean lambda$onClientTick$0(BlockPos playerPos, int renderDistance, long currentTime, Level world, RandomSource random, Minecraft mc, Map.Entry entry) {
            BlockPos pos = (BlockPos)entry.getKey();
            CascadeData cascadeData = (CascadeData)entry.getValue();
            int chunkDistance = Math.max(Math.abs((pos.getX() >> 4) - (playerPos.getX() >> 4)), Math.abs((pos.getZ() >> 4) - (playerPos.getZ() >> 4)));
            if (chunkDistance > renderDistance + 2) {
                return true;
            }
            if (currentTime - cascadeData.createdTime > 100L) {
                if (world.getFluidState(pos).is((Fluid)Fluids.WATER) && world.getFluidState(pos.above()).is((Fluid)Fluids.FLOWING_WATER) && world.getFluidState(pos.below()).is((Fluid)Fluids.WATER)) {
                    int strength = 0;
                    if (world.getFluidState(pos.north()).is((Fluid)Fluids.WATER)) {
                        ++strength;
                    }
                    if (world.getFluidState(pos.east()).is((Fluid)Fluids.WATER)) {
                        ++strength;
                    }
                    if (world.getFluidState(pos.south()).is((Fluid)Fluids.WATER)) {
                        ++strength;
                    }
                    if (world.getFluidState(pos.west()).is((Fluid)Fluids.WATER)) {
                        ++strength;
                    }
                    if (strength > 0) {
                        boolean isEncased;
                        boolean bl = isEncased = !world.getBlockState(pos.above().north()).isAir() && !world.getBlockState(pos.above().east()).isAir() && !world.getBlockState(pos.above().south()).isAir() && !world.getBlockState(pos.above().west()).isAir();
                        if (!isEncased) {
                            cascades.put(pos, new CascadeData(strength, currentTime));
                            return false;
                        }
                    }
                }
                return true;
            }
            if (!(world.getFluidState(pos).is((Fluid)Fluids.WATER) && world.getFluidState(pos.above()).is((Fluid)Fluids.FLOWING_WATER) && world.getFluidState(pos.below()).is((Fluid)Fluids.WATER))) {
                return true;
            }
            float height = world.getFluidState(pos.above()).getOwnHeight();
            double x = pos.getX();
            double y = (double)pos.getY() + random.nextDouble() * (double)height + 1.0;
            double z = pos.getZ();
            if (random.nextBoolean()) {
                x += random.nextDouble();
                z += (double)random.nextIntBetweenInclusive(0, 1);
            } else {
                x += (double)random.nextIntBetweenInclusive(0, 1);
                z += random.nextDouble();
            }
            Particle cascade = mc.particleEngine.createParticle((ParticleOptions)Particles.CASCADE.get(), x, y, z, 0.0, 0.0, 0.0);
            if (cascade != null) {
                float size = (float)cascadeData.strength / 4.0f * height;
                cascade.scale(1.0f - (1.0f - size) / 2.0f);
            }
            return false;
        }
    }
}

