/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.mixin;

import com.leclowndu93150.particular.Main;
import com.leclowndu93150.particular.ParticularConfig;
import com.leclowndu93150.particular.mixin.AccessorChestBlockEntity;
import com.leclowndu93150.particular.mixin.InvokerViewerCountManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChestBlockEntity.class})
public abstract class InjectChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    @Unique
    private int ticksUntilNextSwitch = 20;
    @Unique
    private boolean isOpen = false;
    @Unique
    private static final int minClosedTime = 160;
    @Unique
    private static final int maxClosedTime = 480;
    @Unique
    private static final int minOpenTime = 40;
    @Unique
    private static final int maxOpenTime = 60;

    public InjectChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Unique
    private static boolean getSoulSand(Level world, BlockPos pos, BlockState state) {
        if (world.m_8055_(pos = pos.m_7495_()).m_60734_() == Blocks.f_50135_) {
            return true;
        }
        if (state.m_61143_((Property)BlockStateProperties.f_61392_) == ChestType.RIGHT) {
            BlockPos pos2 = pos.m_121955_(((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_175364_(Direction.Axis.Y).m_122436_());
            return world.m_8055_(pos2).m_60734_() == Blocks.f_50135_;
        }
        return false;
    }

    @Inject(method={"lidAnimateTick"}, at={@At(value="TAIL")})
    private static void randomlyOpen(Level world, BlockPos pos, BlockState state, ChestBlockEntity blockEntity, CallbackInfo ci) {
        if (!ParticularConfig.soulSandBubbles()) {
            return;
        }
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || state.m_61143_((Property)BlockStateProperties.f_61392_) == ChestType.LEFT || !InjectChestBlockEntity.getSoulSand(world, pos, state)) {
            return;
        }
        InjectChestBlockEntity injected = (InjectChestBlockEntity)blockEntity;
        if (--injected.ticksUntilNextSwitch <= 0) {
            ContainerOpenersCounter manager = ((AccessorChestBlockEntity)blockEntity).getStateManager();
            if (injected.isOpen) {
                injected.isOpen = false;
                injected.ticksUntilNextSwitch = world.f_46441_.m_216332_(160, 480);
                ((AccessorChestBlockEntity)blockEntity).getLidAnimator().m_155377_(false);
                ((InvokerViewerCountManager)manager).invokeOnContainerClose(world, pos, blockEntity.m_58900_());
            } else {
                injected.isOpen = true;
                injected.ticksUntilNextSwitch = world.f_46441_.m_216332_(40, 60);
                ((AccessorChestBlockEntity)blockEntity).getLidAnimator().m_155377_(true);
                ((InvokerViewerCountManager)manager).invokeOnContainerOpen(world, pos, blockEntity.m_58900_());
                world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11774_, SoundSource.AMBIENT, 1.0f, 1.0f, true);
            }
        }
        if (injected.isOpen && injected.ticksUntilNextSwitch > 10 && injected.ticksUntilNextSwitch % 2 == 0) {
            if (state.m_61143_((Property)BlockStateProperties.f_61392_) == ChestType.SINGLE) {
                Main.spawnBubble((ParticleOptions)ParticleTypes.f_123774_, world, pos);
            } else {
                Main.spawnDoubleBubbles((ParticleOptions)ParticleTypes.f_123774_, world, pos, state);
            }
        }
    }
}

