/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.mixin;

import com.leclowndu93150.particular.Main;
import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import com.leclowndu93150.particular.mixin.AccessorEnderChestBlockEntity;
import com.leclowndu93150.particular.mixin.InvokerViewerCountManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnderChestBlockEntity.class})
public abstract class InjectEnderChestBlockEntity
extends BlockEntity
implements LidBlockEntity {
    @Unique
    private int ticksUntilNextSwitch = 20;
    @Unique
    private boolean isOpen = false;
    @Unique
    private static final int minClosedTime = 160;
    @Unique
    private static final int maxClosedTime = 480;
    @Unique
    private static final int minOpenTime = 40;
    @Unique
    private static final int maxOpenTime = 60;

    public InjectEnderChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"lidAnimateTick"}, at={@At(value="TAIL")})
    private static void randomlyOpen(Level world, BlockPos pos, BlockState state, EnderChestBlockEntity blockEntity, CallbackInfo ci) {
        if (!ParticularConfig.soulSandBubbles()) {
            return;
        }
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || world.m_8055_(pos.m_7495_()).m_60734_() != Blocks.f_50135_ || world.m_8055_(pos.m_7494_()).m_60796_((BlockGetter)world, pos.m_7494_())) {
            return;
        }
        InjectEnderChestBlockEntity injected = (InjectEnderChestBlockEntity)blockEntity;
        if (--injected.ticksUntilNextSwitch <= 0) {
            ContainerOpenersCounter manager = ((AccessorEnderChestBlockEntity)blockEntity).getStateManager();
            if (injected.isOpen) {
                injected.isOpen = false;
                injected.ticksUntilNextSwitch = world.f_46441_.m_216332_(160, 480);
                ((AccessorEnderChestBlockEntity)blockEntity).getLidAnimator().m_155377_(false);
                ((InvokerViewerCountManager)manager).invokeOnContainerClose(world, pos, blockEntity.m_58900_());
            } else {
                injected.isOpen = true;
                injected.ticksUntilNextSwitch = world.f_46441_.m_216332_(40, 60);
                ((AccessorEnderChestBlockEntity)blockEntity).getLidAnimator().m_155377_(true);
                ((InvokerViewerCountManager)manager).invokeOnContainerOpen(world, pos, blockEntity.m_58900_());
                world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11774_, SoundSource.AMBIENT, 1.0f, 1.0f, true);
            }
        }
        if (injected.isOpen && injected.ticksUntilNextSwitch > 10 && injected.ticksUntilNextSwitch % 2 == 0) {
            Main.spawnBubble((ParticleOptions)Particles.ENDER_BUBBLE.get(), world, pos);
        }
    }
}

