/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.IDynamicModelElementCommon;
import org.cyclops.cyclopscore.config.configurabletypeaction.BlockActionNeoForge;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;

@EventBusSubscriber(modid="cyclopscore", value={Dist.CLIENT})
public class BlockActionNeoForgeClient {
    @SubscribeEvent
    public static void onModelRegistryLoad(ModelEvent.RegisterStandalone event) {
        for (BlockConfigCommon config : BlockActionNeoForge.MODEL_ENTRIES) {
            Pair<BlockState, ResourceLocation> resourceLocations = config.getBlockClientConfig().registerDynamicModel();
            config.getBlockClientConfig().dynamicBlockVariantLocation = (BlockState)resourceLocations.getLeft();
            config.getBlockClientConfig().dynamicItemVariantLocation = (ResourceLocation)resourceLocations.getRight();
        }
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (BlockConfigCommon config : BlockActionNeoForge.MODEL_ENTRIES) {
            IDynamicModelElementCommon dynamicModelElement = config.getBlockClientConfig().getDynamicModelElement();
            BlockStateModel dynamicBlockModel = dynamicModelElement.createDynamicBlockModel(pair -> event.getBakingResult().blockStateModels().put((BlockState)pair.getLeft(), (BlockStateModel)pair.getRight()), key -> (BlockStateModel)event.getBakingResult().blockStateModels().get(key));
            ItemModel dynamicItemModel = dynamicModelElement.createDynamicItemModel(pair -> event.getBakingResult().itemStackModels().put((ResourceLocation)pair.getLeft(), (ItemModel)pair.getRight()), key -> (ItemModel)event.getBakingResult().itemStackModels().get(key));
            if (config.getBlockClientConfig().dynamicBlockVariantLocation != null) {
                event.getBakingResult().blockStateModels().put(config.getBlockClientConfig().dynamicBlockVariantLocation, dynamicBlockModel);
            }
            if (config.getBlockClientConfig().dynamicItemVariantLocation == null) continue;
            event.getBakingResult().itemStackModels().put(config.getBlockClientConfig().dynamicItemVariantLocation, dynamicItemModel);
        }
    }
}

