/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import org.cyclops.cyclopscore.inventory.IValueNotifier;

public class ValueNotifierHelpers {
    public static String KEY = "v";

    public static void setValue(IValueNotifier notifier, int valueId, Tag value) {
        CompoundTag tag = new CompoundTag();
        tag.put(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, int value) {
        CompoundTag tag = new CompoundTag();
        tag.putInt(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, boolean value) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, String value) {
        CompoundTag tag = new CompoundTag();
        tag.putString(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, Component value) {
        if (value != null) {
            CompoundTag tag = new CompoundTag();
            tag.store(KEY, ComponentSerialization.CODEC, (Object)value);
            notifier.setValue(valueId, tag);
        }
    }

    public static void setValue(IValueNotifier notifier, int valueId, List<Component> values) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Component value : values) {
            if (value == null) continue;
            CompoundTag subTag = new CompoundTag();
            subTag.store(KEY, ComponentSerialization.CODEC, (Object)value);
            list.add((Object)subTag);
        }
        tag.put(KEY, (Tag)list);
        notifier.setValue(valueId, tag);
    }

    @Nullable
    public static Tag getValueNbt(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.get(KEY);
        }
        return null;
    }

    public static int getValueInt(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.getIntOr(KEY, 0);
        }
        return 0;
    }

    public static boolean getValueBoolean(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.getBooleanOr(KEY, false);
        }
        return false;
    }

    @Nullable
    public static String getValueString(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.getStringOr(KEY, null);
        }
        return null;
    }

    @Nullable
    public static Component getValueTextComponent(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.read(KEY, ComponentSerialization.CODEC).orElse(null);
        }
        return null;
    }

    @Nullable
    public static List<Component> getValueTextComponentList(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            ListTag listTag = (ListTag)tag.getList(KEY).orElseThrow();
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag subTag = (CompoundTag)listTag.getCompound(i).orElseThrow();
                list.add((Component)subTag.read(KEY, ComponentSerialization.CODEC).orElseThrow());
            }
            return list;
        }
        return null;
    }
}

