/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient.storage;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.commoncapabilities.api.capability.fluidhandler.FluidHandlerFluidStackIterator;
import org.cyclops.commoncapabilities.api.capability.fluidhandler.FluidMatch;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.capability.ICapabilityGetter;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;

public class IngredientComponentStorageWrapperHandlerFluidStack<C>
implements IIngredientComponentStorageWrapperHandler<FluidStack, Integer, IFluidHandler, C> {
    private final IngredientComponent<FluidStack, Integer> ingredientComponent;
    private final BaseCapability<? extends IFluidHandler, C> capability;

    public IngredientComponentStorageWrapperHandlerFluidStack(IngredientComponent<FluidStack, Integer> ingredientComponent, BaseCapability<? extends IFluidHandler, C> capability) {
        this.ingredientComponent = Objects.requireNonNull(ingredientComponent);
        this.capability = capability;
    }

    public static IFluidHandler.FluidAction simulateToFluidAction(boolean simulate) {
        return simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
    }

    public static boolean fluidActionToSimulate(IFluidHandler.FluidAction fluidAction) {
        return fluidAction.simulate();
    }

    @Override
    public IIngredientComponentStorage<FluidStack, Integer> wrapComponentStorage(IFluidHandler storage) {
        return new ComponentStorageWrapper(this.getComponent(), storage);
    }

    @Override
    public IFluidHandler wrapStorage(IIngredientComponentStorage<FluidStack, Integer> componentStorage) {
        if (componentStorage instanceof IIngredientComponentStorageSlotted) {
            return new FluidStorageWrapperSlotted((IIngredientComponentStorageSlotted)componentStorage);
        }
        return new FluidStorageWrapper(componentStorage);
    }

    @Override
    public Optional<IFluidHandler> getStorage(ICapabilityGetter<C> capabilityProvider, @Nullable C context) {
        return Optional.ofNullable(capabilityProvider.getCapability(this.capability, context));
    }

    @Override
    public IngredientComponent<FluidStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    public static class ComponentStorageWrapper
    implements IIngredientComponentStorageSlotted<FluidStack, Integer> {
        private final IngredientComponent<FluidStack, Integer> ingredientComponent;
        private final IFluidHandler storage;

        public ComponentStorageWrapper(IngredientComponent<FluidStack, Integer> ingredientComponent, IFluidHandler storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        @Override
        public IngredientComponent<FluidStack, Integer> getComponent() {
            return this.ingredientComponent;
        }

        @Override
        public Iterator<FluidStack> iterator() {
            return new FluidHandlerFluidStackIterator(this.storage);
        }

        @Override
        public Iterator<FluidStack> iterator(@Nonnull FluidStack prototype, Integer matchFlags) {
            if (this.getComponent().getMatcher().getAnyMatchCondition().equals(matchFlags)) {
                return this.iterator();
            }
            return new FilteredIngredientCollectionIterator(this.iterator(), this.getComponent().getMatcher(), (Object)prototype, (Object)matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            long sum = 0L;
            for (int i = 0; i < this.storage.getTanks(); ++i) {
                sum = Math.addExact(sum, (long)this.storage.getTankCapacity(i));
            }
            return sum;
        }

        @Override
        public FluidStack insert(@Nonnull FluidStack ingredient, boolean simulate) {
            if (ingredient.isEmpty()) {
                return FluidStack.EMPTY;
            }
            int totalAmount = ingredient.getAmount();
            int filledAmount = this.storage.fill(ingredient, IngredientComponentStorageWrapperHandlerFluidStack.simulateToFluidAction(simulate));
            if (filledAmount >= totalAmount) {
                return FluidStack.EMPTY;
            }
            int remaining = totalAmount - filledAmount;
            return new FluidStack(ingredient.getFluid(), remaining);
        }

        @Override
        public FluidStack extract(@Nonnull FluidStack prototype, Integer matchFlags, boolean simulate) {
            if (prototype.isEmpty()) {
                return FluidStack.EMPTY;
            }
            if (matchFlags == 0) {
                return this.storage.drain(IModHelpersNeoForge.get().getFluidHelpers().getAmount(prototype), IngredientComponentStorageWrapperHandlerFluidStack.simulateToFluidAction(simulate));
            }
            if (matchFlags == 4) {
                FluidStack drainedSimulated = this.storage.drain(prototype.getAmount(), IFluidHandler.FluidAction.SIMULATE);
                if (drainedSimulated.isEmpty() || drainedSimulated.getAmount() != prototype.getAmount()) {
                    return FluidStack.EMPTY;
                }
                return simulate ? drainedSimulated : this.storage.drain(prototype.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            }
            for (int i = 0; i < this.storage.getTanks(); ++i) {
                FluidStack contents = this.storage.getFluidInTank(i);
                if (contents.isEmpty() || !FluidMatch.areFluidStacksEqual(contents, prototype, matchFlags & 0xFFFFFFFB)) continue;
                FluidStack toDrain = contents.copy();
                toDrain.setAmount(prototype.getAmount());
                FluidStack drained = this.storage.drain(toDrain, IngredientComponentStorageWrapperHandlerFluidStack.simulateToFluidAction(simulate));
                if (!FluidMatch.areFluidStacksEqual(drained, prototype, matchFlags)) continue;
                return drained;
            }
            return FluidStack.EMPTY;
        }

        @Override
        public FluidStack extract(long maxQuantity, boolean simulate) {
            return this.storage.drain(IModHelpers.get().getBaseHelpers().castSafe(maxQuantity), IngredientComponentStorageWrapperHandlerFluidStack.simulateToFluidAction(simulate));
        }

        @Override
        public int getSlots() {
            return this.storage.getTanks();
        }

        @Override
        public FluidStack getSlotContents(int slot) {
            return this.storage.getFluidInTank(slot);
        }

        @Override
        public long getMaxQuantity(int slot) {
            return this.storage.getTankCapacity(slot);
        }

        @Override
        public FluidStack insert(int slot, @Nonnull FluidStack ingredient, boolean simulate) {
            return this.insert(ingredient, simulate);
        }

        @Override
        public FluidStack extract(int slot, long maxQuantity, boolean simulate) {
            FluidStack slotContents = this.storage.getFluidInTank(slot);
            if (!slotContents.isEmpty()) {
                if ((long)slotContents.getAmount() != maxQuantity) {
                    slotContents = slotContents.copy();
                    slotContents.setAmount((int)maxQuantity);
                }
                return this.storage.drain(slotContents, IngredientComponentStorageWrapperHandlerFluidStack.simulateToFluidAction(simulate));
            }
            return this.extract(maxQuantity, simulate);
        }
    }

    public static class FluidStorageWrapperSlotted
    extends FluidStorageWrapper {
        private final IIngredientComponentStorageSlotted<FluidStack, Integer> storage;

        public FluidStorageWrapperSlotted(IIngredientComponentStorageSlotted<FluidStack, Integer> storage) {
            super(storage);
            this.storage = storage;
        }

        @Override
        public int getTanks() {
            return this.storage.getSlots();
        }

        @Override
        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            int tanks = this.getTanks();
            if (tank < 0 || tank >= tanks) {
                throw new IndexOutOfBoundsException("Tank " + tank + " not in valid range - [0," + tanks + ")");
            }
            return this.storage.getSlotContents(tank);
        }

        @Override
        public int getTankCapacity(int tank) {
            return IModHelpers.get().getBaseHelpers().castSafe(this.storage.getMaxQuantity(tank));
        }
    }

    public static class FluidStorageWrapper
    implements IFluidHandler {
        private final IIngredientComponentStorage<FluidStack, Integer> storage;

        public FluidStorageWrapper(IIngredientComponentStorage<FluidStack, Integer> storage) {
            this.storage = storage;
        }

        public int getTanks() {
            return Iterators.size(this.storage.iterator()) + 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return (FluidStack)Iterables.get(this.storage, (int)tank, (Object)FluidStack.EMPTY);
        }

        public int getTankCapacity(int tank) {
            return IModHelpers.get().getBaseHelpers().castSafe(this.storage.getMaxQuantity());
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return 0;
            }
            FluidStack inserted = this.storage.insert(resource, IngredientComponentStorageWrapperHandlerFluidStack.fluidActionToSimulate(action));
            return inserted.isEmpty() ? resource.getAmount() : resource.getAmount() - inserted.getAmount();
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack extractSimulated = this.storage.extract(resource, 3, true);
            if (extractSimulated != null) {
                FluidStack prototype = resource;
                if (prototype.getAmount() > extractSimulated.getAmount()) {
                    prototype = prototype.copy();
                    prototype.setAmount(extractSimulated.getAmount());
                }
                return this.storage.extract(prototype, 7, IngredientComponentStorageWrapperHandlerFluidStack.fluidActionToSimulate(action));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.storage.extract(maxDrain, IngredientComponentStorageWrapperHandlerFluidStack.fluidActionToSimulate(action));
        }
    }
}

