/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackTag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.IMinecraftHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.jetbrains.annotations.Nullable;

public class VanillaRecipeTypeRecipeHandler<C extends RecipeInput, T extends Recipe<C>>
implements IRecipeHandler {
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_INPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_OUTPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    public static final AbstractContainerMenu DUMMY_CONTAINTER = new AbstractContainerMenu(MenuType.CRAFTING, 0){

        public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
            return ItemStack.EMPTY;
        }

        public boolean stillValid(Player playerIn) {
            return true;
        }
    };
    private final Supplier<Level> worldSupplier;
    private final RecipeType<T> recipeType;
    private final Predicate<Integer> inputSizePredicate;
    private final Function<CraftingContainer, C> createRecipeInput;
    private final boolean ignoreEmptySlots;
    private final boolean checkOutput;
    private static Map<Pair<RecipeType<?>, ResourceLocation>, Collection<IRecipeDefinition>> CACHED_RECIPES = Maps.newHashMap();

    public VanillaRecipeTypeRecipeHandler(Supplier<Level> worldSupplier, RecipeType<T> recipeType, Predicate<Integer> inputSizePredicate, Function<CraftingContainer, C> createRecipeInput, boolean ignoreEmptySlots, boolean checkOutput) {
        this.worldSupplier = worldSupplier;
        this.recipeType = recipeType;
        this.inputSizePredicate = inputSizePredicate;
        this.createRecipeInput = createRecipeInput;
        this.ignoreEmptySlots = ignoreEmptySlots;
        this.checkOutput = checkOutput;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return COMPONENTS_INPUT;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return COMPONENTS_OUTPUT;
    }

    public boolean isValidSizeInput(IngredientComponent component, int size) {
        return component == IngredientComponent.ITEMSTACK && this.inputSizePredicate.test(size);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IPrototypedIngredientAlternatives<ItemStack, Integer> getPrototypesFromDisplay(SlotDisplay display) {
        if (display instanceof SlotDisplay.TagSlotDisplay) {
            SlotDisplay.TagSlotDisplay tagSlotDisplay = (SlotDisplay.TagSlotDisplay)display;
            try {
                TagKey tagKey;
                TagKey tag = tagKey = tagSlotDisplay.tag();
                return new PrototypedIngredientAlternativesItemStackTag(Lists.newArrayList((Object[])new String[]{tag.location().toString()}), 1, 1L);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (display instanceof SlotDisplay.Empty) {
            return new PrototypedIngredientAlternativesList<ItemStack, Integer>(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ItemStack.EMPTY, 1)}));
        }
        if (display instanceof SlotDisplay.ItemStackSlotDisplay) {
            ItemStack stack;
            SlotDisplay.ItemStackSlotDisplay itemStackSlotDisplay = (SlotDisplay.ItemStackSlotDisplay)display;
            {
                ItemStack itemStack;
                stack = itemStack = itemStackSlotDisplay.stack();
            }
            return new PrototypedIngredientAlternativesList<ItemStack, Integer>(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, stack, 5)}));
        }
        PrototypedIngredientAlternativesList<Object, Integer> prototypes = new PrototypedIngredientAlternativesList<ItemStack, Integer>(display.resolveForStacks(ContextMap.EMPTY).stream().map(item -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)item, 1)).collect(Collectors.toList()));
        if (!prototypes.getAlternatives().isEmpty()) return prototypes;
        return new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ItemStack.EMPTY, 1)}));
    }

    public static IPrototypedIngredientAlternatives<ItemStack, Integer> getPrototypesFromIngredient(Ingredient ingredient, @javax.annotation.Nullable SlotDisplay display) {
        if (display != null) {
            return VanillaRecipeTypeRecipeHandler.getPrototypesFromDisplay(display);
        }
        if (ingredient.isCustom()) {
            return new PrototypedIngredientAlternativesList<ItemStack, Integer>(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, new ItemStack((ItemLike)((Holder)ingredient.getCustomIngredient().items().findFirst().get()).value()), 5)}));
        }
        PrototypedIngredientAlternativesList<Object, Integer> prototypes = new PrototypedIngredientAlternativesList<ItemStack, Integer>(ingredient.getValues().stream().map(item -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, new ItemStack(item), 1)).collect(Collectors.toList()));
        if (prototypes.getAlternatives().isEmpty()) {
            prototypes = new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ItemStack.EMPTY, 1)}));
        }
        return prototypes;
    }

    @javax.annotation.Nullable
    public static <C extends RecipeInput, T extends Recipe<C>> IRecipeDefinition recipeToRecipeDefinition(T recipe, Level level) {
        ArrayList inputIngredients;
        ItemStack recipeOutput = IModHelpers.get().getMinecraftHelpers().getRecipeOutput(recipe, level);
        if (recipeOutput.isEmpty()) {
            return null;
        }
        List ingredients = recipe.placementInfo().ingredients();
        int inputSize = ingredients.size();
        if (inputSize == 0) {
            return null;
        }
        RecipeDisplay recipeDisplay = (RecipeDisplay)recipe.display().get(0);
        if (recipe instanceof ShapedRecipe) {
            int width = 3;
            int height = 3;
            inputIngredients = Lists.newArrayListWithCapacity((int)9);
            for (int i = 0; i < width * height; ++i) {
                inputIngredients.add(new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponents.ITEMSTACK, ItemStack.EMPTY, 5)})));
            }
            ShapedCraftingRecipeDisplay recipeDisplayShaped = (ShapedCraftingRecipeDisplay)recipeDisplay;
            PlaceRecipeHelper.placeRecipe((int)width, (int)height, (int)recipeDisplayShaped.width(), (int)recipeDisplayShaped.height(), (Iterable)recipeDisplayShaped.ingredients(), (display, destinationSlot, x, y) -> inputIngredients.set(destinationSlot, VanillaRecipeTypeRecipeHandler.getPrototypesFromDisplay(display)));
        } else {
            List list;
            inputIngredients = Lists.newArrayListWithCapacity((int)inputSize);
            if (recipeDisplay instanceof ShapelessCraftingRecipeDisplay) {
                ShapelessCraftingRecipeDisplay recipeDisplayShapeless = (ShapelessCraftingRecipeDisplay)recipeDisplay;
                list = recipeDisplayShapeless.ingredients();
            } else {
                list = null;
            }
            List displayIngredients = list;
            for (int i = 0; i < ingredients.size(); ++i) {
                inputIngredients.add(i, VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient((Ingredient)ingredients.get(i), displayIngredients != null ? (SlotDisplay)displayIngredients.get(i) : null));
            }
        }
        return RecipeDefinition.ofAlternatives(IngredientComponent.ITEMSTACK, inputIngredients, MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, recipeOutput));
    }

    @Override
    public Collection<IRecipeDefinition> getRecipes() {
        Pair cacheKey = Pair.of(this.recipeType, (Object)this.worldSupplier.get().dimension().location());
        Collection cached = CACHED_RECIPES.get(cacheKey);
        if (cached == null) {
            RecipeAccess recipeAccess = this.worldSupplier.get().recipeAccess();
            if (recipeAccess instanceof RecipeManager) {
                RecipeManager recipeManager = (RecipeManager)recipeAccess;
                cached = recipeManager.getRecipes().stream().filter(holder -> holder.value().getType() == this.recipeType && !holder.value().isSpecial()).map(recipe -> VanillaRecipeTypeRecipeHandler.recipeToRecipeDefinition(recipe.value(), this.worldSupplier.get())).filter(Objects::nonNull).collect(Collectors.toList());
            } else {
                cached = Collections.emptyList();
            }
            CACHED_RECIPES.put(cacheKey, cached);
        }
        return cached;
    }

    @Override
    @javax.annotation.Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        C recipeInput = this.createNewRecipeInput(input);
        if (recipeInput == null) {
            return null;
        }
        Recipe recipe = IModHelpers.get().getCraftingHelpers().findRecipeCached(this.recipeType, recipeInput, this.worldSupplier.get(), true).map(RecipeHolder::value).orElse(null);
        if (recipe == null) {
            return null;
        }
        return MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, IModHelpers.get().getMinecraftHelpers().getRecipeOutput(recipe, this.worldSupplier.get()));
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public IMixedIngredients simulate(IRecipeDefinition recipe) {
        MixedIngredients input = MixedIngredients.fromRecipeInput(recipe);
        if (this.checkOutput) {
            C recipeInput = this.createNewRecipeInput(input);
            if (recipeInput == null) {
                return null;
            }
            IMixedIngredients output = recipe.getOutput();
            List<ItemStack> recipeOutputs = output.getInstances(IngredientComponent.ITEMSTACK);
            if (output.getComponents().size() != 1 || recipeOutputs.size() != 1) {
                return null;
            }
            ItemStack recipeOutput = recipeOutputs.getFirst();
            ServerLevel level = (ServerLevel)this.worldSupplier.get();
            IMinecraftHelpers mcHelpers = IModHelpers.get().getMinecraftHelpers();
            return IModHelpers.get().getCraftingHelpers().findRecipes(level, this.recipeType).stream().filter(recipeHolder -> recipeHolder.value().matches(recipeInput, (Level)level) && ItemStack.isSameItemSameComponents((ItemStack)mcHelpers.getRecipeOutput(recipeHolder, this.worldSupplier.get()), (ItemStack)recipeOutput)).findFirst().map(recipeHolder -> MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, mcHelpers.getRecipeOutput(recipeHolder, this.worldSupplier.get()))).orElse(null);
        }
        return this.simulate(input);
    }

    @javax.annotation.Nullable
    protected C createNewRecipeInput(IMixedIngredients input) {
        List<ItemStack> recipeIngredients = input.getInstances(IngredientComponent.ITEMSTACK);
        if (this.ignoreEmptySlots) {
            recipeIngredients = recipeIngredients.stream().filter(itemStack -> !itemStack.isEmpty()).toList();
        }
        if (input.getComponents().size() != 1 || recipeIngredients.isEmpty()) {
            return null;
        }
        TransientCraftingContainer inventoryCrafting = new TransientCraftingContainer(DUMMY_CONTAINTER, 3, 3);
        for (int i = 0; i < recipeIngredients.size(); ++i) {
            inventoryCrafting.setItem(i, recipeIngredients.get(i));
        }
        return (C)((RecipeInput)this.createRecipeInput.apply((CraftingContainer)inventoryCrafting));
    }
}

