/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part.aspect;

import java.util.Collection;
import java.util.Comparator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;

public interface IAspect<V extends IValue, T extends IValueType<V>> {
    public ResourceLocation getUniqueName();

    public String getTranslationKey();

    public void loadTooltip(Consumer<Component> var1, boolean var2);

    public T getValueType();

    public <P extends IPartType<P, S>, S extends IPartState<P>> void update(INetwork var1, IPartNetwork var2, P var3, PartTarget var4, S var5);

    public <P extends IPartType<P, S>, S extends IPartState<P>> boolean hasProperties();

    public <P extends IPartType<P, S>, S extends IPartState<P>> IAspectProperties getProperties(P var1, PartTarget var2, S var3);

    public <P extends IPartType<P, S>, S extends IPartState<P>> void setProperties(P var1, PartTarget var2, S var3, IAspectProperties var4);

    @Nullable
    public IAspectProperties getDefaultProperties();

    public Collection<IAspectPropertyTypeInstance> getPropertyTypes();

    public MenuProvider getPropertiesContainerProvider(PartPos var1);

    public static class AspectComparator
    implements Comparator<IAspect> {
        private static AspectComparator INSTANCE = null;

        private AspectComparator() {
        }

        public static AspectComparator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new AspectComparator();
            }
            return INSTANCE;
        }

        @Override
        public int compare(IAspect o1, IAspect o2) {
            return o1.getUniqueName().compareTo(o2.getUniqueName());
        }
    }
}

