/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.subgui;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiHolder;

public abstract class SubGuiBox
implements ISubGuiBox {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"textures/gui/sub_gui.png");
    private final Box type;
    protected List<Button> buttonList = Lists.newArrayList();
    protected final SubGuiHolder subGuiHolder = new SubGuiHolder();

    public SubGuiBox(Box type) {
        this.type = type;
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        this.buttonList.clear();
        this.subGuiHolder.init(guiLeft, guiTop);
    }

    public void drawScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.buttonList.size(); ++i) {
            this.buttonList.get(i).render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected boolean isDrawBackground() {
        return true;
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        if (this.isDrawBackground()) {
            int currentHeight;
            int i;
            int currentWidth;
            int textureWidth;
            int textureHeight = textureWidth = 19;
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            int width = this.getWidth();
            int height = this.getHeight();
            int tx = this.type.getX();
            int ty = this.type.getY();
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y, (float)tx, (float)tx, 1, 1, 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x + width - 1, y, (float)(tx + textureWidth - 1), (float)ty, 1, 1, 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y + height - 1, 0.0f, (float)(tx + textureHeight - 1), ty + 1, 1, 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x + width - 1, y + height - 1, (float)(tx + textureWidth - 1), (float)(ty + textureHeight - 1), 1, 1, 256, 256);
            for (i = 1; i < width - 1; i += currentWidth) {
                currentWidth = Math.max(1, Math.min(width - i, textureWidth - 2) - 1);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x + i, y, (float)(tx + 1), (float)ty, currentWidth, 1, 256, 256);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x + i, y + height - 1, (float)(tx + 1), (float)(ty + textureHeight - 1), currentWidth, 1, 256, 256);
            }
            for (i = 1; i < height - 1; i += currentHeight) {
                currentHeight = Math.max(1, Math.min(height - i, textureHeight - 2) - 1);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y + i, (float)tx, (float)(ty + 1), 1, currentHeight, 256, 256);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x + width - 1, y + i, (float)(tx + textureWidth - 1), (float)(ty + 1), 1, currentHeight, 256, 256);
            }
            for (i = 1; i < width - 1; i += currentWidth) {
                int currentHeight2;
                currentWidth = Math.max(1, Math.min(width - i, textureWidth - 2) - 1);
                for (int j = 1; j < height - 1; j += currentHeight2) {
                    currentHeight2 = Math.max(1, Math.min(height - j, textureHeight - 2) - 1);
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x + i, y + j, (float)(tx + 1), (float)(ty + 1), currentWidth, currentHeight2, 256, 256);
                }
            }
        }
        this.drawScreen(guiGraphics, mouseX, mouseY, partialTicks);
        this.subGuiHolder.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
        this.subGuiHolder.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        return this.subGuiHolder.charTyped(typedChar, keyCode);
    }

    @Override
    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        return this.subGuiHolder.keyPressed(typedChar, keyCode, modifiers);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.subGuiHolder.mouseClicked(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.buttonList.size(); ++i) {
            Button guibutton = this.buttonList.get(i);
            if (!guibutton.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            guibutton.playDownSound(Minecraft.getInstance().getSoundManager());
            this.actionPerformed(guibutton);
            return true;
        }
        return false;
    }

    protected void actionPerformed(Button guibutton) {
    }

    public static enum Box {
        LIGHT(0, 0),
        DARK(0, 19);

        private final int x;
        private final int y;

        private Box(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    public static class Base
    extends SubGuiBox {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public Base(Box type, int x, int y, int width, int height) {
            super(type);
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void init(int guiLeft, int guiTop) {
        }

        @Override
        public void tick() {
        }

        @Override
        public boolean charTyped(char typedChar, int keyCode) {
            return false;
        }

        @Override
        public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
            return false;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }
}

