/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeCategory;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.core.evaluate.operator.CurriedOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class ValueHelpers {
    public static IValueType[] from(IVariable ... variables) {
        IValueType[] valueTypes = new IValueType[variables.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IVariable variable = variables[i];
            valueTypes[i] = variable == null ? null : variable.getType();
        }
        return valueTypes;
    }

    public static IValueType<?>[] from(IVariableFacade ... variableFacades) {
        IValueType[] valueTypes = new IValueType[variableFacades.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IVariableFacade variableFacade = variableFacades[i];
            valueTypes[i] = variableFacade == null ? null : variableFacade.getOutputType();
        }
        return valueTypes;
    }

    public static Component[] from(IValueType<?> ... valueTypes) {
        Component[] names = new Component[valueTypes.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            IValueType<?> valueType = valueTypes[i];
            names[i] = Component.translatable((String)valueType.getTranslationKey());
        }
        return names;
    }

    public static boolean areValuesEqual(@Nullable IValue v1, @Nullable IValue v2) {
        return v1 == null && v2 == null || v1 != null && v2 != null && v1.equals(v2);
    }

    public static boolean correspondsTo(IValueType t1, IValueType t2) {
        return t1.correspondsTo(t2) || t2.correspondsTo(t1);
    }

    public static boolean correspondsTo(IVariable<?> variable, IValueType type) {
        if (type != ValueTypes.CATEGORY_ANY && variable.getType() == ValueTypes.CATEGORY_ANY) {
            try {
                Object value = variable.getValue();
                return ValueHelpers.correspondsTo(type, value.getType());
            }
            catch (EvaluationException e) {
                return false;
            }
        }
        return ValueHelpers.correspondsTo(type, variable.getType());
    }

    public static IValue evaluateOperator(IOperator operator, IValue ... values) throws EvaluationException {
        IVariable[] variables = new IVariable[values.length];
        for (int i = 0; i < variables.length; ++i) {
            IValue value = values[i];
            variables[i] = new Variable<IValue>(value.getType(), value);
        }
        return ValueHelpers.evaluateOperator(operator, variables);
    }

    public static IValue evaluateOperator(IOperator operator, IVariable ... variables) throws EvaluationException {
        int requiredLength = operator.getRequiredInputLength();
        if (requiredLength == variables.length) {
            return operator.evaluate(variables);
        }
        if (variables.length > requiredLength) {
            IVariable[] acceptableVariables = (IVariable[])ArrayUtils.subarray((Object[])variables, (int)0, (int)requiredLength);
            IVariable[] remainingVariables = (IVariable[])ArrayUtils.subarray((Object[])variables, (int)requiredLength, (int)variables.length);
            IValue result = ValueHelpers.evaluateOperator(operator, acceptableVariables);
            if (result.getType() != ValueTypes.OPERATOR) {
                throw new EvaluationException(Component.translatable((String)"operator.integrateddynamics.error.currying_overflow", (Object[])new Object[]{Component.translatable((String)operator.getTranslationKey()), requiredLength, variables.length, Component.translatable((String)result.getType().getTranslationKey())}));
            }
            IOperator nextOperator = ((ValueTypeOperator.ValueOperator)result).getRawValue();
            return ValueHelpers.evaluateOperator(nextOperator, remainingVariables);
        }
        return ValueTypeOperator.ValueOperator.of(new CurriedOperator(operator, variables));
    }

    public static void serializeRaw(ValueOutput valueOutput, IValue value) {
        value.getType().serialize(valueOutput, value);
    }

    public static void serialize(ValueOutput valueOutput, IValue value) {
        valueOutput.putString("valueType", value.getType().getUniqueName().toString());
        ValueHelpers.serializeRaw(valueOutput, value);
    }

    public static IValue deserialize(ValueInput input) {
        IValueType valueType = ValueTypes.REGISTRY.getValueType(ResourceLocation.parse((String)((String)input.getString("valueType").orElseThrow())));
        if (valueType == null) {
            return null;
        }
        return ValueHelpers.deserializeRaw(input, valueType);
    }

    public static <T extends IValue> T deserializeRaw(ValueInput valueInput, IValueType<T> valueType) {
        return valueType.deserialize(valueInput);
    }

    public static <T extends IValue> String toString(T value) {
        return value.getType().toString(value);
    }

    public static <T extends IValue> T parseString(IValueType<T> valueType, String value) throws EvaluationException {
        return valueType.parseString(value);
    }

    public static void validatePredicateOutput(IOperator predicate, IValue result) throws EvaluationException {
        if (!(result instanceof ValueTypeBoolean.ValueBoolean)) {
            MutableComponent error = Component.translatable((String)"operator.integrateddynamics.error.wrong_predicate", (Object[])new Object[]{predicate.getLocalizedNameFull(), Component.translatable((String)result.getType().getTranslationKey()), Component.translatable((String)ValueTypes.BOOLEAN.getTranslationKey())});
            throw new EvaluationException(error);
        }
    }

    public static Pair<MutableComponent, Integer> getSafeReadableValue(@Nullable IVariable variable) {
        MutableComponent readValue = Component.literal((String)"");
        int readValueColor = 0;
        if (!NetworkHelpers.shouldWork()) {
            readValue = Component.literal((String)"SAFE-MODE");
        } else if (variable != null) {
            try {
                Object value = variable.getValue();
                readValue = value.getType().toCompactString(value);
                readValueColor = value.getType().getDisplayColor();
            }
            catch (NullPointerException | PartStateException | EvaluationException e) {
                readValue = Component.literal((String)"ERROR");
                readValueColor = IModHelpers.get().getBaseHelpers().RGBToInt(255, 0, 0);
            }
        }
        return Pair.of((Object)readValue, (Object)readValueColor);
    }

    public static ResourceLocation createResourceLocationInEvaluation(String value) throws EvaluationException {
        try {
            return ResourceLocation.parse((String)value);
        }
        catch (ResourceLocationException e) {
            throw new EvaluationException(Component.literal((String)e.getMessage()));
        }
    }

    public static <V extends IValue, C extends IValueType<V>> C variableUnpackAnyType(IVariable variable, IOperator operator, IValueTypeCategory<V> category, Class<? super C> categoryClazz) throws EvaluationException {
        IValueType type = variable.getType();
        if (type == ValueTypes.CATEGORY_ANY && !categoryClazz.isInstance(type = variable.getValue().getType())) {
            throw new EvaluationException(Component.translatable((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{operator.getLocalizedNameFull(), Component.translatable((String)type.getTranslationKey()), "0", Component.translatable((String)category.getTranslationKey())}));
        }
        return (C)type;
    }
}

