/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeLightLevelRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLightLevelRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeLightLevels {
    public static final IValueTypeLightLevelRegistry REGISTRY = ValueTypeLightLevels.constructRegistry();

    private static IValueTypeLightLevelRegistry constructRegistry() {
        if (IModHelpers.get().getMinecraftHelpers().isModdedEnvironment()) {
            return (IValueTypeLightLevelRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IValueTypeLightLevelRegistry.class);
        }
        return ValueTypeLightLevelRegistry.getInstance();
    }

    public static void load() {
        REGISTRY.register(ValueTypes.INTEGER, new IValueTypeLightLevelRegistry.ILightLevelCalculator<ValueTypeInteger.ValueInteger>(){

            @Override
            public int getLightLevel(ValueTypeInteger.ValueInteger value) {
                return Math.max(0, Math.min(value.getRawValue(), 15));
            }
        });
        REGISTRY.register(ValueTypes.BOOLEAN, new IValueTypeLightLevelRegistry.ILightLevelCalculator<ValueTypeBoolean.ValueBoolean>(){

            @Override
            public int getLightLevel(ValueTypeBoolean.ValueBoolean value) {
                return value.getRawValue() ? 15 : 0;
            }
        });
    }
}

