/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeString
extends ValueTypeBase<ValueString>
implements IValueTypeNamed<ValueString> {
    public ValueTypeString() {
        super("string", IModHelpers.get().getBaseHelpers().RGBToInt(250, 10, 13), ChatFormatting.RED, ValueString.class);
    }

    @Override
    public ValueString getDefault() {
        return ValueString.of("");
    }

    @Override
    public MutableComponent toCompactString(ValueString value) {
        return Component.literal((String)value.getRawValue());
    }

    @Override
    public void serialize(ValueOutput valueOutput, ValueString value) {
        valueOutput.putString("v", value.getRawValue());
    }

    @Override
    public ValueString deserialize(ValueInput valueInput) {
        return ValueString.of((String)valueInput.getString("v").orElseThrow());
    }

    @Override
    public String toString(ValueString value) {
        return value.getRawValue();
    }

    @Override
    public ValueString parseString(String value) throws EvaluationException {
        return ValueString.of(value);
    }

    @Override
    public String getName(ValueString a) {
        return a.getRawValue();
    }

    public static class ValueString
    extends ValueBase {
        private final String value;

        private ValueString(String value) {
            super(ValueTypes.STRING);
            this.value = value;
        }

        public static ValueString of(String value) {
            return new ValueString(value);
        }

        public String getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ValueString && ((ValueString)o).value.equals(this.value);
        }

        public int hashCode() {
            return this.getType().hashCode() + this.value.hashCode();
        }

        @Override
        public String toString() {
            return "ValueTypeString.ValueString(value=" + this.value + ")";
        }
    }
}

