/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.network.event.NetworkInitializedEvent;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class CableHelpers {
    public static final Collection<Direction> ALL_SIDES = Sets.newIdentityHashSet();
    private static WeakReference<LivingEntity> CABLE_PLACER_SNAPSHOT;
    private static final Map<Pair<ResourceKey<Level>, BlockPos>, Collection<Direction>> CABLE_REMOVING_CONNECTIONS;
    private static boolean removingCable;

    @Deprecated
    public static Optional<ICable> getCable(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        return IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(world, pos, (Object)side, Capabilities.Cable.BLOCK);
    }

    public static Optional<ICable> getCable(ILevelExtension world, BlockPos pos, @Nullable Direction side, @Nullable BlockState blockState) {
        return Optional.ofNullable((ICable)world.getCapability(Capabilities.Cable.BLOCK, pos, blockState, null, (Object)side));
    }

    @Deprecated
    public static Optional<ICableFakeable> getCableFakeable(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        return IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(world, pos, (Object)side, Capabilities.CableFakeable.BLOCK);
    }

    public static Optional<ICableFakeable> getCableFakeable(ILevelExtension world, BlockPos pos, @Nullable Direction side, BlockState blockState) {
        return Optional.ofNullable((ICableFakeable)world.getCapability(Capabilities.CableFakeable.BLOCK, pos, blockState, null, (Object)side));
    }

    public static Optional<IPathElement> getPathElement(ILevelExtension world, BlockPos pos, @Nullable Direction side, BlockState blockState) {
        return Optional.ofNullable((IPathElement)world.getCapability(Capabilities.PathElement.BLOCK, pos, blockState, null, (Object)side));
    }

    public static void updateConnectionsNeighbours(ILevelExtension world, BlockPos pos, Collection<Direction> sides) {
        for (Direction side : sides) {
            CableHelpers.updateConnections(world, pos.relative(side), side.getOpposite());
        }
    }

    public static void updateConnections(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        CableHelpers.getCable(world, pos, side).ifPresent(ICable::updateConnections);
    }

    public static boolean isCableConnected(ILevelExtension world, BlockPos pos, Direction side, BlockState blockState) {
        return CableHelpers.getCable(world, pos, side, blockState).map(cable -> cable.isConnected(side)).orElse(false);
    }

    public static boolean canCableConnectTo(ILevelExtension world, BlockPos pos, Direction side, ICable originCable) {
        BlockPos neighbourPos = pos.relative(side);
        return CableHelpers.getCable(world, neighbourPos, side.getOpposite()).map(neighbourCable -> originCable.canConnect((ICable)neighbourCable, side) && neighbourCable.canConnect(originCable, side.getOpposite())).orElse(false);
    }

    @Deprecated
    public static boolean isNoFakeCable(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        return CableHelpers.getCableFakeable(world, pos, side).map(ICableFakeable::isRealCable).orElse(true);
    }

    public static boolean isNoFakeCable(ILevelExtension world, BlockPos pos, @Nullable Direction side, BlockState blockState) {
        return CableHelpers.getCableFakeable(world, pos, side, blockState).map(ICableFakeable::isRealCable).orElse(true);
    }

    public static void disconnectCable(Level world, BlockPos pos, Direction side, ICable cable, Direction disconnectSide) {
        cable.disconnect(disconnectSide);
        cable.updateConnections();
        Collection<Direction> sidesToUpdate = CableHelpers.getCableConnections(cable);
        sidesToUpdate.add(disconnectSide);
        CableHelpers.updateConnectionsNeighbours((ILevelExtension)world, pos, sidesToUpdate);
        NetworkHelpers.initNetwork((ILevelExtension)world, pos, side);
        NetworkHelpers.initNetwork((ILevelExtension)world, pos.relative(disconnectSide), side.getOpposite());
    }

    public static InteractionResult onCableActivated(Level world, BlockPos pos, BlockState state, Player player, ItemStack heldItem, Direction side, @Nullable Direction cableConnectionHit) {
        ICable cable = CableHelpers.getCable((ILevelExtension)world, pos, side).orElse(null);
        if (cable == null) {
            return InteractionResult.PASS;
        }
        if (WrenchHelpers.isWrench(player, heldItem, world, pos, side)) {
            BlockPos neighbourPos;
            ICable neighbourCable;
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (player.isSecondaryUseActive()) {
                CableHelpers.removeCable(world, pos, player);
            } else if (cableConnectionHit != null) {
                CableHelpers.disconnectCable(world, pos, side, cable, cableConnectionHit);
            } else if (cableConnectionHit == null && (neighbourCable = (ICable)CableHelpers.getCable((ILevelExtension)world, neighbourPos = pos.relative(side), side.getOpposite()).orElse(null)) != null && !cable.isConnected(side) && (cable.canConnect(neighbourCable, side) || neighbourCable.canConnect(cable, side.getOpposite()))) {
                cable.reconnect(side);
                neighbourCable.reconnect(side.getOpposite());
                cable.updateConnections();
                Collection<Direction> sidesToUpdate = CableHelpers.getCableConnections(cable);
                sidesToUpdate.add(side);
                CableHelpers.updateConnectionsNeighbours((ILevelExtension)world, pos, sidesToUpdate);
                NetworkHelpers.initNetwork((ILevelExtension)world, pos, side);
                NetworkHelpers.initNetwork((ILevelExtension)world, neighbourPos, side.getOpposite());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void onCableAdded(Level world, BlockPos pos) {
        LivingEntity placer = (LivingEntity)CABLE_PLACER_SNAPSHOT.get();
        if (placer != null) {
            CableHelpers.onCableAddedByPlayer(world, pos, placer);
            CABLE_PLACER_SNAPSHOT = new WeakReference<Object>(null);
        } else {
            CableHelpers.onCableAddedByPlayerActual(world, pos, null);
        }
    }

    public static void onCableAddedByPlayer(Level world, BlockPos pos, @Nullable LivingEntity placer) {
        if (world.captureBlockSnapshots) {
            CABLE_PLACER_SNAPSHOT = new WeakReference<LivingEntity>(placer);
        } else {
            CableHelpers.onCableAddedByPlayerActual(world, pos, placer);
        }
    }

    public static void onCableAddedByPlayerActual(Level world, BlockPos pos, @Nullable LivingEntity placer) {
        CableHelpers.updateConnectionsNeighbours((ILevelExtension)world, pos, ALL_SIDES);
        if (!world.isClientSide()) {
            NetworkHelpers.initNetwork((ILevelExtension)world, pos, null).ifPresent(network -> NeoForge.EVENT_BUS.post((Event)new NetworkInitializedEvent((INetwork)network, world, pos, placer)));
        }
    }

    public static void overrideCableRemovingConnections(Level level, BlockPos pos, Collection<Direction> sides) {
        CABLE_REMOVING_CONNECTIONS.put((Pair<ResourceKey<Level>, BlockPos>)Pair.of((Object)level.dimension(), (Object)pos), sides);
    }

    public static boolean onCableRemoving(Level world, BlockPos pos, boolean dropMainElement, boolean saveState, BlockState blockState, BlockEntity blockEntity) {
        CABLE_REMOVING_CONNECTIONS.put((Pair<ResourceKey<Level>, BlockPos>)Pair.of((Object)world.dimension(), (Object)pos), CableHelpers.getExternallyConnectedCables(world, pos));
        if (!world.isClientSide() && CableHelpers.isNoFakeCable((ILevelExtension)world, pos, null)) {
            INetworkCarrier networkCarrier = NetworkHelpers.getNetworkCarrier((ILevelExtension)world, pos, null, blockState).orElse(null);
            LinkedList itemStacks = Lists.newLinkedList();
            INetworkElementProvider networkElementProvider = NetworkHelpers.getNetworkElementProvider((ILevelExtension)world, pos, null, blockState).orElse(null);
            if (networkElementProvider != null) {
                for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                    networkElement.addDrops(blockState, blockEntity, itemStacks, dropMainElement, saveState);
                }
                for (ItemStack itemStack : itemStacks) {
                    Block.popResource((Level)world, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
            if (networkCarrier != null && networkCarrier.getNetwork() != null) {
                IPathElement pathElement = CableHelpers.getPathElement((ILevelExtension)world, pos, null, blockState).orElseThrow(() -> new IllegalStateException("Could not find a valid path element capability"));
                return CableHelpers.onCableRemovingNetwork(blockState, blockEntity, networkCarrier, pathElement);
            }
        }
        return true;
    }

    public static boolean onCableRemovingNetwork(BlockState blockState, BlockEntity blockEntity, INetworkCarrier networkCarrier, IPathElement pathElement) {
        INetwork network = networkCarrier.getNetwork();
        networkCarrier.setNetwork(null);
        return network.removePathElement(pathElement, null, blockState, blockEntity);
    }

    public static boolean onCableRemoved(Level world, BlockPos pos) {
        Collection<Direction> sides = CABLE_REMOVING_CONNECTIONS.remove(Pair.of((Object)world.dimension(), (Object)pos));
        if (sides == null) {
            sides = Collections.emptyList();
        }
        CableHelpers.updateConnectionsNeighbours((ILevelExtension)world, pos, sides);
        if (!world.isClientSide()) {
            for (Direction side : sides) {
                BlockPos sidePos = pos.relative(side);
                NetworkHelpers.initNetwork((ILevelExtension)world, sidePos, side.getOpposite());
            }
        }
        return true;
    }

    public static boolean isRemovingCable() {
        return removingCable;
    }

    public static void setRemovingCable(boolean removingCable) {
        CableHelpers.removingCable = removingCable;
    }

    public static void removeCable(Level world, BlockPos pos, @Nullable Player player) {
        removingCable = true;
        BlockState blockState = world.getBlockState(pos);
        ICable cable = CableHelpers.getCable((ILevelExtension)world, pos, null, blockState).orElse(null);
        ICableFakeable cableFakeable = CableHelpers.getCableFakeable((ILevelExtension)world, pos, null, blockState).orElse(null);
        IPartContainer partContainer = PartHelpers.getPartContainer((ILevelExtension)world, pos, null, blockState).orElse(null);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (cable == null) {
            removingCable = false;
            return;
        }
        CableHelpers.onCableRemoving(world, pos, false, false, blockState, blockEntity);
        if (cableFakeable == null || partContainer == null || !partContainer.hasParts()) {
            cable.destroy();
        } else {
            cableFakeable.setRealCable(false);
        }
        if (player == null) {
            IModHelpers.get().getItemStackHelpers().spawnItemStack(world, pos, cable.getItemStack());
        } else if (!player.isCreative()) {
            IModHelpers.get().getItemStackHelpers().spawnItemStackToPlayer(world, pos, cable.getItemStack(), player);
        }
        CableHelpers.onCableRemoved(world, pos);
        ItemBlockCable.playBreakSound(world, pos, blockState);
        removingCable = false;
    }

    public static boolean hasFacade(ILevelExtension world, BlockPos pos, BlockState blockState) {
        return Optional.ofNullable((IFacadeable)world.getCapability(Capabilities.Facadeable.BLOCK, pos, blockState, null, null)).map(IFacadeable::hasFacade).orElse(false);
    }

    public static Optional<BlockState> getFacade(ILevelExtension world, BlockPos pos, BlockState blockState) {
        return Optional.ofNullable((IFacadeable)world.getCapability(Capabilities.Facadeable.BLOCK, pos, blockState, null, null)).flatMap(facadeable -> Optional.ofNullable(facadeable.getFacade()));
    }

    public static boolean isLightTransparent(Level world, BlockPos pos, @Nullable Direction side, BlockState blockState) {
        return PartHelpers.getPartContainer((ILevelExtension)world, pos, side, blockState).map(partContainer -> {
            for (Map.Entry<Direction, IPartType<?, ?>> entry : partContainer.getParts().entrySet()) {
                IPartType<?, ?> part = entry.getValue();
                if (!part.forceLightTransparency(partContainer.getPartState(entry.getKey()))) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public static Collection<Direction> getCableConnections(ICable cable) {
        Set sides = Sets.newIdentityHashSet();
        for (Direction side : Direction.values()) {
            if (!cable.isConnected(side)) continue;
            sides.add(side);
        }
        return sides;
    }

    public static Collection<Direction> getExternallyConnectedCables(Level world, BlockPos pos) {
        Set sides = Sets.newIdentityHashSet();
        for (Direction side : Direction.values()) {
            if (!CableHelpers.isCableConnected((ILevelExtension)world, pos.relative(side), side.getOpposite(), null)) continue;
            sides.add(side);
        }
        return sides;
    }

    static {
        for (Direction side : Direction.values()) {
            ALL_SIDES.add(side);
        }
        CABLE_PLACER_SNAPSHOT = new WeakReference<Object>(null);
        CABLE_REMOVING_CONNECTIONS = Maps.newConcurrentMap();
        removingCable = false;
    }
}

