/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;

public class ItemBlockEnergyContainerAutoSupply
extends ItemBlockEnergyContainer {
    public ItemBlockEnergyContainerAutoSupply(Block block, Item.Properties builder) {
        super(block, builder);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        IModHelpers.get().getL10NHelpers().addStatusInfo(tooltipAdder, this.isActivated(itemStack), this.getDescriptionId() + ".info.auto_supply");
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        return InteractionResult.SUCCESS.heldItemTransformedTo(this.toggleActivation(player.getItemInHand(hand), world, player));
    }

    public static void autofill(IEnergyStorage source, Level world, Entity entity) {
        int tickAmount;
        if (entity instanceof Player && !world.isClientSide() && (tickAmount = source.extractEnergy(Integer.MAX_VALUE, true)) > 0) {
            Player player = (Player)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack held = player.getItemInHand(hand);
                ItemStack filled = ItemBlockEnergyContainerAutoSupply.tryFillContainerForPlayer(source, held, tickAmount, player);
                if (filled.isEmpty()) continue;
                player.setItemInHand(hand, filled);
            }
        }
    }

    public static ItemStack tryFillContainerForPlayer(IEnergyStorage source, ItemStack held, int tickAmount, Player player) {
        int moved;
        IEnergyStorage target = (IEnergyStorage)held.getCapability(Capabilities.EnergyStorage.ITEM, null);
        if (target != null && (moved = target.receiveEnergy(source.extractEnergy(target.receiveEnergy(tickAmount, true), false), false)) > 0) {
            return held;
        }
        return ItemStack.EMPTY;
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel world, Entity entity, @Nullable EquipmentSlot slot) {
        IEnergyStorage energyStorage;
        if (this.isActivated(itemStack) && (energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM, null)) != null) {
            ItemBlockEnergyContainerAutoSupply.autofill(energyStorage, (Level)world, entity);
        }
        super.inventoryTick(itemStack, world, entity, slot);
    }

    public ItemStack toggleActivation(ItemStack itemStack, Level world, Player player) {
        if (player.isSecondaryUseActive()) {
            if (!world.isClientSide()) {
                ItemStack activated;
                activated.set(RegistryEntries.DATACOMPONENT_ACTIVATED, (Object)((Boolean)(activated = itemStack.copy()).getOrDefault(RegistryEntries.DATACOMPONENT_ACTIVATED, (Object)false) == false ? 1 : 0));
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    public boolean isActivated(ItemStack itemStack) {
        return (Boolean)itemStack.getOrDefault(RegistryEntries.DATACOMPONENT_ACTIVATED, (Object)false);
    }

    public boolean isFoil(ItemStack itemStack) {
        return this.isActivated(itemStack);
    }
}

