/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.persist.world.GlobalCounters;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeClient;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;

public abstract class VariableFacadeBase
implements IVariableFacade {
    private final int id;
    private IVariableFacadeClient client;

    public VariableFacadeBase(boolean generateId) {
        this(generateId ? VariableFacadeBase.generateId() : -1);
    }

    public VariableFacadeBase(int id) {
        this.id = id;
        if (IModHelpers.get().getMinecraftHelpers().isClientSide()) {
            this.client = this.constructClient();
        }
    }

    protected abstract IVariableFacadeClient constructClient();

    @Override
    public IVariableFacadeClient getClient() {
        return this.client;
    }

    public static int generateId() {
        return ((GlobalCounters)IntegratedDynamics.globalCounters.get()).getNext("variable");
    }

    @Override
    public String getLabel() {
        return LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().getLabel(this.getId());
    }

    protected String getReferenceDisplay(int variableId) {
        String label = LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().getLabel(variableId);
        if (label == null) {
            return String.valueOf(variableId);
        }
        return String.format("%s:%s", label, variableId);
    }

    @Override
    public void appendHoverText(Consumer<Component> tooltipAdder, Item.TooltipContext context) {
        tooltipAdder.accept((Component)Component.translatable((String)"item.integrateddynamics.variable.id", (Object[])new Object[]{this.getId() == -1 ? "..." : Integer.valueOf(this.getId())}));
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setClient(IVariableFacadeClient client) {
        this.client = client;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableFacadeBase)) {
            return false;
        }
        VariableFacadeBase other = (VariableFacadeBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        IVariableFacadeClient this$client = this.getClient();
        IVariableFacadeClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VariableFacadeBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        IVariableFacadeClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    public String toString() {
        return "VariableFacadeBase(id=" + this.getId() + ", client=" + String.valueOf(this.getClient()) + ")";
    }
}

