/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeClient;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.DummyVariableFacadeClient;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.event.LogicProgrammerVariableFacadeCreatedEvent;

public class VariableFacadeHandlerRegistry
implements IVariableFacadeHandlerRegistry {
    private static VariableFacadeHandlerRegistry INSTANCE = new VariableFacadeHandlerRegistry();
    public static DummyVariableFacade DUMMY_FACADE = new DummyVariableFacade("variable.integrateddynamics.error.invalid_item");
    private final Map<String, IVariableFacadeHandler> handlers = Maps.newHashMap();

    private VariableFacadeHandlerRegistry() {
    }

    public static VariableFacadeHandlerRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerHandler(IVariableFacadeHandler variableFacadeHandler) {
        this.handlers.put(variableFacadeHandler.getUniqueName().toString(), variableFacadeHandler);
    }

    @Override
    public IVariableFacade handle(ValueDeseralizationContext valueDeseralizationContext, ItemStack itemStack) {
        if (itemStack.isEmpty() || !itemStack.has(RegistryEntries.DATACOMPONENT_VARIABLE_FACADE)) {
            return DUMMY_FACADE;
        }
        return this.handle(valueDeseralizationContext, (CompoundTag)itemStack.get(RegistryEntries.DATACOMPONENT_VARIABLE_FACADE));
    }

    @Override
    public IVariableFacade handle(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tagCompound) {
        if (tagCompound == null) {
            return DUMMY_FACADE;
        }
        if (!tagCompound.contains("_type") || !tagCompound.contains("_id")) {
            return DUMMY_FACADE;
        }
        String type = (String)tagCompound.getString("_type").orElseThrow();
        int id = (Integer)tagCompound.getInt("_id").orElseThrow();
        IVariableFacadeHandler handler = this.getHandler(ResourceLocation.parse((String)type));
        if (handler != null) {
            return handler.getVariableFacade(valueDeseralizationContext, id, tagCompound);
        }
        return DUMMY_FACADE;
    }

    @Override
    @Nullable
    public IVariableFacadeHandler getHandler(ResourceLocation type) {
        return this.handlers.get(type.toString());
    }

    @Override
    public Collection<String> getHandlerNames() {
        return this.handlers.keySet();
    }

    @Override
    public <F extends IVariableFacade> void write(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tagCompound, F variableFacade, IVariableFacadeHandler<F> handler) {
        tagCompound.putString("_type", handler.getUniqueName().toString());
        tagCompound.putInt("_id", variableFacade.getId());
        handler.setVariableFacade(valueDeseralizationContext, tagCompound, variableFacade);
    }

    @Override
    public <F extends IVariableFacade> ItemStack writeVariableFacadeItem(ItemStack itemStack, F variableFacade, IVariableFacadeHandler<F> variableFacadeHandler) {
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        itemStack = itemStack.copy();
        CompoundTag tag = new CompoundTag();
        this.write(ValueDeseralizationContext.ofAllEnabled(), tag, variableFacade, variableFacadeHandler);
        itemStack.set(RegistryEntries.DATACOMPONENT_VARIABLE_FACADE, (Object)tag);
        return itemStack;
    }

    @Override
    public <F extends IVariableFacade> ItemStack writeVariableFacadeItem(boolean generateId, ItemStack itemStack, IVariableFacadeHandler<F> variableFacadeHandler, IVariableFacadeHandlerRegistry.IVariableFacadeFactory<F> variableFacadeFactory, Level level, @Nullable Player player, @Nullable BlockState blockState) {
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        itemStack = itemStack.copy();
        CompoundTag tag = new CompoundTag();
        F variableFacade = this.writeVariableFacade(generateId, itemStack, variableFacadeHandler, variableFacadeFactory, ValueDeseralizationContext.of(level));
        if (player != null) {
            NeoForge.EVENT_BUS.post((Event)new LogicProgrammerVariableFacadeCreatedEvent(player, (IVariableFacade)variableFacade, blockState));
        }
        this.write(ValueDeseralizationContext.of(level), tag, variableFacade, variableFacadeHandler);
        itemStack.set(RegistryEntries.DATACOMPONENT_VARIABLE_FACADE, (Object)tag);
        return itemStack;
    }

    @Override
    public <F extends IVariableFacade> F writeVariableFacade(boolean generateId, ItemStack itemStack, IVariableFacadeHandler<F> variableFacadeHandler, IVariableFacadeHandlerRegistry.IVariableFacadeFactory<F> variableFacadeFactory, ValueDeseralizationContext valueDeseralizationContext) {
        if (itemStack.isEmpty()) {
            return null;
        }
        CompoundTag tag = Objects.requireNonNullElseGet((CompoundTag)itemStack.get(RegistryEntries.DATACOMPONENT_VARIABLE_FACADE), CompoundTag::new).copy();
        IVariableFacade previousVariableFacade = this.handle(valueDeseralizationContext, tag);
        F variableFacade = generateId && previousVariableFacade.getId() > -1 ? variableFacadeFactory.create(previousVariableFacade.getId()) : variableFacadeFactory.create(generateId);
        itemStack.set(RegistryEntries.DATACOMPONENT_VARIABLE_FACADE, (Object)tag);
        return variableFacade;
    }

    @Override
    public <F extends IVariableFacade> ItemStack copy(boolean generateId, ItemStack itemStack) {
        ItemStack copy = itemStack.copy();
        int newId = generateId ? VariableFacadeBase.generateId() : -1;
        CompoundTag tagCopy = ((CompoundTag)itemStack.get(RegistryEntries.DATACOMPONENT_VARIABLE_FACADE)).copy();
        tagCopy.putInt("_id", newId);
        copy.set(RegistryEntries.DATACOMPONENT_VARIABLE_FACADE, (Object)tagCopy);
        return copy;
    }

    public static class DummyVariableFacade
    extends VariableFacadeBase {
        private static final IVariable VARIABLE_TRUE = new VariableAdapter<ValueTypeBoolean.ValueBoolean>(){

            @Override
            public IValueType<ValueTypeBoolean.ValueBoolean> getType() {
                return ValueTypes.BOOLEAN;
            }

            @Override
            public ValueTypeBoolean.ValueBoolean getValue() throws EvaluationException {
                return ValueTypeBoolean.ValueBoolean.of(true);
            }
        };
        private final String unlocalizedError;

        public DummyVariableFacade(String unlocalizedError) {
            super(false);
            this.unlocalizedError = unlocalizedError;
        }

        @Override
        public <V extends IValue> IVariable<V> getVariable(INetwork network, IPartNetwork partNetwork) {
            return VARIABLE_TRUE;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void validate(INetwork network, IPartNetwork partNetwork, IVariableFacade.IValidator validator, IValueType containingValueType) {
            if (!ValueHelpers.correspondsTo(containingValueType, (IValueType)ValueTypes.BOOLEAN)) {
                validator.addError(Component.translatable((String)this.unlocalizedError));
            }
        }

        @Override
        public IValueType getOutputType() {
            return ValueTypes.CATEGORY_ANY;
        }

        @Override
        protected IVariableFacadeClient constructClient() {
            return new DummyVariableFacadeClient();
        }

        @Override
        public void appendHoverText(Consumer<Component> tooltipAdder, Item.TooltipContext context) {
        }
    }
}

