/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.aspect.property;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.logging.log4j.Level;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectPropertyTypeInstance;

public class AspectProperties
implements IAspectProperties {
    private final Map<IAspectPropertyTypeInstance, IValue> values = Maps.newLinkedHashMap();

    public AspectProperties(Collection<IAspectPropertyTypeInstance> propertyTypes) {
        for (IAspectPropertyTypeInstance propertyType : propertyTypes) {
            this.values.put(propertyType, (IValue)propertyType.getType().getDefault());
        }
    }

    public AspectProperties() {
    }

    @Override
    @Deprecated
    public Collection<IAspectPropertyTypeInstance> getTypes() {
        return Collections.unmodifiableCollection(this.values.keySet());
    }

    @Override
    public <T extends IValueType<V>, V extends IValue> V getValue(IAspectPropertyTypeInstance<T, V> type) {
        IValue value = this.values.get(type);
        if (value == null) {
            value = type.getType().getDefault();
        }
        return (V)value;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue> void setValue(IAspectPropertyTypeInstance<T, V> type, V value) {
        this.values.put(type, value);
    }

    @Override
    public <T extends IValueType<V>, V extends IValue> void removeValue(IAspectPropertyTypeInstance<T, V> type) {
        this.values.remove(type);
    }

    @Override
    public void serialize(ValueOutput valueOutput) {
        ValueOutput.ValueOutputList map = valueOutput.childrenList("map");
        for (Map.Entry<IAspectPropertyTypeInstance, IValue> entry : this.values.entrySet()) {
            ValueOutput nbtEntry = map.addChild();
            nbtEntry.putString("key", entry.getKey().getType().getUniqueName().toString());
            nbtEntry.putString("label", entry.getKey().getTranslationKey());
            ValueHelpers.serializeRaw(nbtEntry.child("value"), entry.getValue());
        }
    }

    @Override
    public void deserialize(ValueInput valueInput) {
        this.values.clear();
        for (ValueInput entry : (ValueInput.ValueInputList)valueInput.childrenList("map").orElseThrow()) {
            String valueTypeName = (String)entry.getString("key").orElseThrow();
            IValueType type = ValueTypes.REGISTRY.getValueType(ResourceLocation.parse((String)valueTypeName));
            if (type == null) {
                IntegratedDynamics.clog(Level.ERROR, String.format("Could not find value type with name %s, skipping loading.", valueTypeName));
                continue;
            }
            Object value = ValueHelpers.deserializeRaw((ValueInput)entry.child("value").orElseThrow(), type);
            String label = (String)entry.getString("label").orElseThrow();
            if (value == null) {
                IntegratedDynamics.clog(Level.ERROR, String.format("The value type %s could not load its value, using default.", valueTypeName));
                value = type.getDefault();
            }
            this.values.put(new AspectPropertyTypeInstance(type, label), (IValue)value);
        }
    }

    @Override
    public IAspectProperties clone() {
        AspectProperties clone = new AspectProperties(this.getTypes());
        for (IAspectPropertyTypeInstance type : this.getTypes()) {
            clone.setValue(type, this.getValue(type));
        }
        return clone;
    }
}

