/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest.integration;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.OminousBottleAmplifier;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.core.test.TestHelpers;
import org.cyclops.integrateddynamics.gametest.integration.Asserts;
import org.cyclops.integrateddynamics.gametest.integration.DummyValueType;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariable;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableBlock;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableItemStack;

public class TestItemStackOperators {
    private static final DummyValueType DUMMY_TYPE = DummyValueType.TYPE;
    private static final DummyVariable<DummyValueType.DummyValue> DUMMY_VARIABLE = new DummyVariable<DummyValueType.DummyValue>(DUMMY_TYPE, DummyValueType.DummyValue.of());
    private DummyVariableItemStack iApple;
    private DummyVariableItemStack iAppleNoData;
    private DummyVariableItemStack iApple2;
    private DummyVariableItemStack iAppleTag;
    private DummyVariableItemStack iBeef;
    private DummyVariableItemStack iEnderPearl;
    private DummyVariableItemStack iHoe;
    private DummyVariableItemStack iHoe100;
    private DummyVariableItemStack iHoeEnchanted;
    private DummyVariableItemStack iPickaxe;
    private DummyVariableItemStack iStone;
    private DummyVariableItemStack iDarkOakLeaves;
    private DummyVariableItemStack iBucketLava;
    private DummyVariableItemStack iWrench;
    private DummyVariableItemStack iEnergyBatteryEmpty;
    private DummyVariableItemStack iEnergyBatteryFull;
    private DummyVariableItemStack iIronOre;
    private DummyVariableItemStack iShulkerBox;
    private DummyVariableItemStack iSeedWheat;
    private DummyVariableItemStack iEmpty;
    private DummyVariableBlock bStone;
    private DummyVariableBlock bObsidian;
    private DummyVariable<ValueTypeString.ValueString> sPlankWood;
    private DummyVariable<ValueTypeString.ValueString> sMaxStackSize;
    private DummyVariable<ValueTypeInteger.ValueInteger> int100;
    private DummyVariable<ValueTypeInteger.ValueInteger> int200;
    private DummyVariable<ValueTypeString.ValueString> sApple;
    private DummyVariable<ValueTypeList.ValueList> lApples;
    private DummyVariable<ValueTypeNbt.ValueNbt> t4;

    @IntegrationBefore
    public void before() {
        this.iApple = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.APPLE)));
        this.iAppleNoData = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.APPLE)));
        ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().remove(DataComponents.MAX_STACK_SIZE);
        ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().remove(DataComponents.LORE);
        ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().remove(DataComponents.ENCHANTMENTS);
        ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().remove(DataComponents.REPAIR_COST);
        ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().remove(DataComponents.ATTRIBUTE_MODIFIERS);
        ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().remove(DataComponents.RARITY);
        ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().remove(DataComponents.FOOD);
        ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().remove(DataComponents.ITEM_NAME);
        ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().remove(DataComponents.ITEM_MODEL);
        ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().remove(DataComponents.CONSUMABLE);
        this.iApple2 = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.APPLE, 2)));
        ItemStack appleStack = new ItemStack((ItemLike)Items.APPLE);
        appleStack.set(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, (Object)new OminousBottleAmplifier(2));
        this.iAppleTag = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(appleStack));
        this.iBeef = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.RED_BED)));
        this.iEnderPearl = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.ENDER_PEARL)));
        this.iHoe = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.DIAMOND_HOE)));
        this.iHoe100 = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.DIAMOND_HOE)));
        ((ValueObjectTypeItemStack.ValueItemStack)this.iHoe100.getValue()).getRawValue().setDamageValue(100);
        ItemStack hoeEnchanted = new ItemStack((ItemLike)Items.DIAMOND_HOE);
        EnchantmentHelpers.setEnchantmentLevel((ItemStack)hoeEnchanted, (Holder)ServerLifecycleHooks.getCurrentServer().registryAccess().holderOrThrow(Enchantments.AQUA_AFFINITY), (int)1);
        hoeEnchanted.set(DataComponents.REPAIR_COST, (Object)10);
        this.iHoeEnchanted = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(hoeEnchanted));
        this.iPickaxe = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE)));
        this.iStone = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Blocks.STONE)));
        this.iDarkOakLeaves = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Blocks.DARK_OAK_LEAVES, 1)));
        this.iBucketLava = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.LAVA_BUCKET)));
        this.iWrench = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack(RegistryEntries.ITEM_WRENCH)));
        this.iEnergyBatteryEmpty = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack(RegistryEntries.ITEM_ENERGY_BATTERY)));
        ItemStack energyBatteryFull = new ItemStack(RegistryEntries.ITEM_ENERGY_BATTERY);
        IEnergyStorage energyStorage = (IEnergyStorage)energyBatteryFull.getCapability(Capabilities.EnergyStorage.ITEM);
        BlockEnergyBatteryBase.fill(energyStorage);
        this.iEnergyBatteryFull = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(energyBatteryFull));
        this.iIronOre = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Blocks.IRON_ORE)));
        ItemStack shulkerBox = new ItemStack((ItemLike)Blocks.BLACK_SHULKER_BOX);
        IItemHandler itemHandler = (IItemHandler)shulkerBox.getCapability(Capabilities.ItemHandler.ITEM);
        itemHandler.insertItem(0, new ItemStack((ItemLike)Items.APPLE), false);
        itemHandler.insertItem(10, new ItemStack((ItemLike)Items.APPLE, 10), false);
        this.iShulkerBox = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(shulkerBox));
        this.iSeedWheat = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.WHEAT_SEEDS)));
        this.iEmpty = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY));
        this.bStone = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(Blocks.STONE.defaultBlockState()));
        this.bObsidian = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(Blocks.OBSIDIAN.defaultBlockState()));
        this.sPlankWood = new DummyVariable<ValueTypeString.ValueString>(ValueTypes.STRING, ValueTypeString.ValueString.of("minecraft:planks"));
        this.sMaxStackSize = new DummyVariable<ValueTypeString.ValueString>(ValueTypes.STRING, ValueTypeString.ValueString.of("minecraft:max_stack_size"));
        this.int100 = new DummyVariable<ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of(100));
        this.int200 = new DummyVariable<ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of(200));
        this.sApple = new DummyVariable<ValueTypeString.ValueString>(ValueTypes.STRING, ValueTypeString.ValueString.of("minecraft:apple"));
        this.lApples = new DummyVariable<ValueTypeList.ValueList>(ValueTypes.LIST, ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeItemStack.ValueItemStack[]{(ValueObjectTypeItemStack.ValueItemStack)this.iApple.getValue(), (ValueObjectTypeItemStack.ValueItemStack)this.iApple2.getValue(), (ValueObjectTypeItemStack.ValueItemStack)this.iIronOre.getValue(), (ValueObjectTypeItemStack.ValueItemStack)this.iApple.getValue(), (ValueObjectTypeItemStack.ValueItemStack)this.iApple.getValue(), (ValueObjectTypeItemStack.ValueItemStack)this.iHoe.getValue(), (ValueObjectTypeItemStack.ValueItemStack)this.iHoe100.getValue(), (ValueObjectTypeItemStack.ValueItemStack)this.iApple2.getValue()}));
        this.t4 = new DummyVariable<ValueTypeNbt.ValueNbt>(ValueTypes.NBT, ValueTypeNbt.ValueNbt.of((Tag)IntTag.valueOf((int)4)));
    }

    @IntegrationTest
    public void testItemStackSize() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_SIZE.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 1, "size(apple:1) = 1");
        IValue res2 = Operators.OBJECT_ITEMSTACK_SIZE.evaluate(this.iApple2);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 2, "size(apple:2) = 2");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeSizeLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_SIZE.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeSizeSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_SIZE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeSize() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_SIZE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackMaxSize() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_MAXSIZE.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 64, "maxsize(apple) = 64");
        IValue res2 = Operators.OBJECT_ITEMSTACK_MAXSIZE.evaluate(this.iEnderPearl);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 16, "maxsize(enderpearl) = 16");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputMaxSizeMaxSizeLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_MAXSIZE.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputMaxSizeMaxSizeSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_MAXSIZE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeMaxSize() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_MAXSIZE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackIsStackable() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_ISSTACKABLE.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), true, "isstackable(apple) = true");
        IValue res2 = Operators.OBJECT_ITEMSTACK_ISSTACKABLE.evaluate(this.iHoe);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), false, "isstackable(hoe) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsStackableIsStackableLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISSTACKABLE.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsStackableIsStackableSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISSTACKABLE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsStackable() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISSTACKABLE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackIsDamageable() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_ISDAMAGEABLE.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isdamageable(apple) = false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_ISDAMAGEABLE.evaluate(this.iHoe);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isdamageable(hoe) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsDamageableIsDamageableLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISDAMAGEABLE.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsDamageableIsDamageableSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISDAMAGEABLE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsDamageable() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISDAMAGEABLE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackDamage() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_DAMAGE.evaluate(this.iHoe);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 0, "damage(hoe:0) = 0");
        IValue res2 = Operators.OBJECT_ITEMSTACK_DAMAGE.evaluate(this.iHoe100);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 100, "damage(hoe:100) = 100");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputDamageDamageLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DAMAGE.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputDamageDamageSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DAMAGE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeDamage() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DAMAGE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackMaxDamage() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_MAXDAMAGE.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 0, "maxdamage(apple) = 0");
        IValue res2 = Operators.OBJECT_ITEMSTACK_MAXDAMAGE.evaluate(this.iHoe);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 1561, "maxdamage(hoe) = 1561");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputMaxDamageMaxDamageLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_MAXDAMAGE.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputMaxDamageMaxDamageSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_MAXDAMAGE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeMaxDamage() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_MAXDAMAGE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackIsEnchanted() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_ISENCHANTED.evaluate(this.iHoe);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isenchanted(hoe) = false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_ISENCHANTED.evaluate(this.iHoeEnchanted);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isenchanted(hoeenchanted) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsEnchantedIsEnchantedLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISENCHANTED.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsEnchantedIsEnchantedSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISENCHANTED.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsEnchanted() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISENCHANTED.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackIsEnchantable() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_ISENCHANTABLE.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isenchantable(apple) = false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_ISENCHANTABLE.evaluate(this.iHoe);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isenchantable(hoe) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsEnchantableIsEnchantableLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISENCHANTABLE.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsEnchantableIsEnchantableSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISENCHANTABLE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsEnchantable() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISENCHANTABLE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackRepairCost() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_REPAIRCOST.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 0, "repaircost(apple) = 0");
        IValue res2 = Operators.OBJECT_ITEMSTACK_REPAIRCOST.evaluate(this.iHoeEnchanted);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 10, "repaircost(hoe:10) = 10");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputRepairCostRepairCostLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_REPAIRCOST.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputRepairCostRepairCostSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_REPAIRCOST.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeRepairCost() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_REPAIRCOST.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackRarity() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_RARITY.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), Rarity.COMMON.name(), "rarity(apple) = common");
        IValue res2 = Operators.OBJECT_ITEMSTACK_RARITY.evaluate(this.iHoeEnchanted);
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res2).getRawValue(), Rarity.RARE.name(), "rarity(hoeenchanted) = rare");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputRarityRarityLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_RARITY.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputRarityRaritySmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_RARITY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeRarity() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_RARITY.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackStrengthVsBlock() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_STRENGTH_VS_BLOCK.evaluate(this.iHoe, this.bStone);
        Asserts.check(res1 instanceof ValueTypeDouble.ValueDouble, "result is a double");
        TestHelpers.assertEqual(((ValueTypeDouble.ValueDouble)res1).getRawValue(), 1.0, "strengthvsblock(hoe, stone) = 1.0");
        IValue res2 = Operators.OBJECT_ITEMSTACK_STRENGTH_VS_BLOCK.evaluate(this.iPickaxe, this.bStone);
        TestHelpers.assertEqual(((ValueTypeDouble.ValueDouble)res2).getRawValue(), 8.0, "strengthvsblock(pickaxe, stone) = 8.0");
        IValue res3 = Operators.OBJECT_ITEMSTACK_STRENGTH_VS_BLOCK.evaluate(this.iPickaxe, this.bObsidian);
        TestHelpers.assertEqual(((ValueTypeDouble.ValueDouble)res3).getRawValue(), 8.0, "strengthvsblock(pickaxe, obsidian) = 8.0");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputStrengthVsBlockStrengthVsBlockLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_STRENGTH_VS_BLOCK.evaluate(this.iApple, this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputStrengthVsBlockStrengthVsBlockSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_STRENGTH_VS_BLOCK.evaluate(this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeStrengthVsBlock() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_STRENGTH_VS_BLOCK.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackCanHarvestBlock() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK.evaluate(this.iHoe, this.bStone);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "canharvestblock(hoe, stone) = false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK.evaluate(this.iPickaxe, this.bStone);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "canharvestblock(pickaxe, stone) = true");
        IValue res3 = Operators.OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK.evaluate(this.iPickaxe, this.bObsidian);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), true, "canharvestblock(pickaxe, obsidian) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputCanHarvestBlockCanHarvestBlockLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK.evaluate(this.iApple, this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputCanHarvestBlockCanHarvestBlockSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK.evaluate(this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeCanHarvestBlock() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackBlock() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_BLOCK.evaluate(this.iStone);
        Asserts.check(res1 instanceof ValueObjectTypeBlock.ValueBlock, "result is a block");
        TestHelpers.assertEqual((BlockState)((ValueObjectTypeBlock.ValueBlock)res1).getRawValue().get(), Blocks.STONE.defaultBlockState(), "block(stone) = stone");
        IValue res2 = Operators.OBJECT_ITEMSTACK_BLOCK.evaluate(this.iDarkOakLeaves);
        TestHelpers.assertEqual((BlockState)((ValueObjectTypeBlock.ValueBlock)res2).getRawValue().get(), (BlockState)((BlockState)Blocks.DARK_OAK_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(false)), "block(dark_oak_leaves) = dark_oak_leaves");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputBlockBlockLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_BLOCK.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputBlockBlockSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_BLOCK.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeBlock() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_BLOCK.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackIsFluidStack() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_ISFLUIDSTACK.evaluate(this.iHoe);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isfluidstack(hoe) = false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_ISFLUIDSTACK.evaluate(this.iBucketLava);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isfluidstack(bucketlava) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsFluidStackIsFluidStackLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISFLUIDSTACK.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsFluidStackIsFluidStackSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISFLUIDSTACK.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsFluidStack() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISFLUIDSTACK.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackFluidStack() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_FLUIDSTACK.evaluate(this.iHoe);
        Asserts.check(res1 instanceof ValueObjectTypeFluidStack.ValueFluidStack, "result is a fluidstack");
        TestHelpers.assertEqual(((ValueObjectTypeFluidStack.ValueFluidStack)res1).getRawValue().isEmpty(), true, "fluidstack(hoe) = null");
        IValue res2 = Operators.OBJECT_ITEMSTACK_FLUIDSTACK.evaluate(this.iBucketLava);
        TestHelpers.assertEqual(FluidStack.matches((FluidStack)((ValueObjectTypeFluidStack.ValueFluidStack)res2).getRawValue(), (FluidStack)new FluidStack((Fluid)Fluids.LAVA, IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume())), true, "fluidstack(bucketlava) = lava:1000");
        IValue res3 = Operators.OBJECT_ITEMSTACK_FLUIDSTACK.evaluate(this.iEmpty);
        TestHelpers.assertEqual(FluidStack.matches((FluidStack)((ValueObjectTypeFluidStack.ValueFluidStack)res3).getRawValue(), (FluidStack)FluidStack.EMPTY), true, "fluidstack(empty) = empty");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputFluidStackFluidStackLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FLUIDSTACK.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputFluidStackFluidStackSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FLUIDSTACK.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeFluidStack() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FLUIDSTACK.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackFluidStackCapacity() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_FLUIDSTACKCAPACITY.evaluate(this.iHoe);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is a fluidstack");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 0, "fluidstackcapacity(hoe) = 0");
        IValue res2 = Operators.OBJECT_ITEMSTACK_FLUIDSTACKCAPACITY.evaluate(this.iBucketLava);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), "fluidstackcapacity(bucketlava) = 1000");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputFluidStackCapacityFluidStackCapacityLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FLUIDSTACKCAPACITY.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputFluidStackCapacityFluidStackCapacitySmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FLUIDSTACKCAPACITY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeFluidStackCapacity() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FLUIDSTACKCAPACITY.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackIsNBTEqual() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_ISDATAEQUAL.evaluate(this.iHoe, this.iPickaxe);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isnbtequal(hoe, pickaxe) = false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_ISDATAEQUAL.evaluate(this.iHoe, this.iHoeEnchanted);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), false, "isnbtequal(hoe, hoeenchanted) = false");
        IValue res3 = Operators.OBJECT_ITEMSTACK_ISDATAEQUAL.evaluate(this.iPickaxe, this.iPickaxe);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), true, "isnbtequal(pickaxe, pickaxe) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsNBTEqualIsNBTEqualLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISDATAEQUAL.evaluate(this.iApple, this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsNBTEqualIsNBTEqualSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISDATAEQUAL.evaluate(this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsNBTEqual() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISDATAEQUAL.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackIsItemEqualNoNBT() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iHoe, this.iPickaxe);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "israwitemequal(hoe, pickaxe) = false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iHoe, this.iHoeEnchanted);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "israwitemequal(hoe, hoeenchanted) = true");
        IValue res3 = Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iPickaxe, this.iPickaxe);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), true, "israwitemequal(pickaxe, pickaxe) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsItemEqualNoNBTLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iApple, this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsItemEqualNoNBTSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsItemEqualNoNBT() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackIsRawItemEqual() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iHoe, this.iPickaxe);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "israwitemequal(hoe, pickaxe) = false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iHoe, this.iHoeEnchanted);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "israwitemequal(hoe, hoeenchanted) = true");
        IValue res3 = Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iPickaxe, this.iPickaxe);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), true, "israwitemequal(pickaxe, pickaxe) = true");
        IValue res4 = Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iHoe, this.iHoe100);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res4).getRawValue(), true, "israwitemequal(hoe, hoe:100) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsRawItemEqualIsRawItemEqualLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iApple, this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsRawItemEqualIsRawItemEqualSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsRawItemEqual() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISRAWITEMEQUAL.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackModName() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_MODNAME.evaluate(this.iHoe);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), "Minecraft", "modname(hoe) = Minecraft");
        IValue res2 = Operators.OBJECT_ITEMSTACK_MODNAME.evaluate(this.iWrench);
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res2).getRawValue(), "IntegratedDynamics", "modname(wrench) = IntegratedDynamics");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeModNameLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_MODNAME.evaluate(this.iHoe, this.iHoe);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeModNameSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_MODNAME.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeModName() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_MODNAME.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackFuelBurnTime() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_FUELBURNTIME.evaluate(this.iBucketLava);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 20000, "fuelburntime(bucketlava) = 20000");
        IValue res2 = Operators.OBJECT_ITEMSTACK_FUELBURNTIME.evaluate(this.iApple);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 0, "fuelburntime(apple) = 0");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputFuelBurnTimeFuelBurnTimeLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FUELBURNTIME.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputFuelBurnTimeFuelBurnTimeSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FUELBURNTIME.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeFuelBurnTime() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FUELBURNTIME.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackCanBurn() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_CANBURN.evaluate(this.iBucketLava);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), true, "canburn(bucketlava) = true");
        IValue res2 = Operators.OBJECT_ITEMSTACK_CANBURN.evaluate(this.iApple);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), false, "canburn(apple) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputCanBurnCanBurnLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_CANBURN.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputCanBurnCanBurnSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_CANBURN.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeCanBurn() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_CANBURN.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackTag() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_TAG.evaluate(this.iStone);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), 2, "size(tag(stone)) = 2");
        IValue res2 = Operators.OBJECT_ITEMSTACK_TAG.evaluate(this.iWrench);
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res2).getRawValue().getLength(), 2, "size(tag(wrench)) = 2");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_TAG.evaluate(this.iHoe, this.iHoe);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_TAG.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTag() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_TAG.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackTagStacks() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_TAG_STACKS.evaluate(this.sPlankWood);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), (int)Helpers.getTagValues("minecraft:planks").count(), "size(tag_stacks(plankWood))");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagStacksLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_TAG_STACKS.evaluate(this.sPlankWood, this.sPlankWood);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagStacksSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_TAG_STACKS.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTagStacks() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_TAG_STACKS.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackWithSize() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_WITHSIZE.evaluate(this.iApple, this.int100);
        Asserts.check(res1 instanceof ValueObjectTypeItemStack.ValueItemStack, "result is an itemstack");
        TestHelpers.assertEqual(((ValueObjectTypeItemStack.ValueItemStack)res1).getRawValue().getCount(), 100, "withsize(apple, 100).stacksize == 100");
        IValue res2 = Operators.OBJECT_ITEMSTACK_WITHSIZE.evaluate(this.iBeef, this.int200);
        TestHelpers.assertEqual(((ValueObjectTypeItemStack.ValueItemStack)res2).getRawValue().getCount(), 200, "withsize(beef, 200).stacksize == 200");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeWithSizeLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_WITHSIZE.evaluate(this.iApple, this.int100, this.int100);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeWithSizeSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_WITHSIZE.evaluate(this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeWithSize() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_WITHSIZE.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackIsFeContainer() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_ISFECONTAINER.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isfecontainer(apple) == false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_ISFECONTAINER.evaluate(this.iEnergyBatteryEmpty);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isfecontainer(energyBatteryEmpty) == true");
        IValue res3 = Operators.OBJECT_ITEMSTACK_ISFECONTAINER.evaluate(this.iEnergyBatteryFull);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), true, "isfecontainer(energyBatteryFull) == true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsFeContainerLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISFECONTAINER.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsFeContainerSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISFECONTAINER.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsFeContainer() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_ISFECONTAINER.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackStoredFe() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_STOREDFE.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 0, "storedfe(apple) == false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_STOREDFE.evaluate(this.iEnergyBatteryEmpty);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 0, "storedfe(energyBatteryEmpty) == 0");
        IValue res3 = Operators.OBJECT_ITEMSTACK_STOREDFE.evaluate(this.iEnergyBatteryFull);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res3).getRawValue(), BlockEnergyBatteryConfig.capacity, "storedfe(energyBatteryFull) == BlockEnergyBatteryConfig.capacity");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeStoredFeLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_STOREDFE.evaluate(this.iEnergyBatteryEmpty, this.iEnergyBatteryEmpty);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeStoredFeSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_STOREDFE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeStoredFe() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_STOREDFE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackFeCapacity() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_FECAPACITY.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 0, "fecapacity(apple) == false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_FECAPACITY.evaluate(this.iEnergyBatteryEmpty);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), BlockEnergyBatteryConfig.capacity, "fecapacity(energyBatteryEmpty) == BlockEnergyBatteryConfig.capacity");
        IValue res3 = Operators.OBJECT_ITEMSTACK_FECAPACITY.evaluate(this.iEnergyBatteryFull);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res3).getRawValue(), BlockEnergyBatteryConfig.capacity, "fecapacity(energyBatteryFull) == BlockEnergyBatteryConfig.capacity");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeFeCapacityLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FECAPACITY.evaluate(this.iEnergyBatteryEmpty, this.iEnergyBatteryEmpty);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeFeCapacitySmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FECAPACITY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeFeCapacity() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_FECAPACITY.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackHasInventory() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_HASINVENTORY.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "hasinventory(apple) == false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_HASINVENTORY.evaluate(this.iShulkerBox);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "hasinventory(shulkerbox) == true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHasInventoryLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_HASINVENTORY.evaluate(this.iApple, this.int100);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHasInventorySmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_HASINVENTORY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeHasInventory() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_HASINVENTORY.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackInventorySize() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_INVENTORYSIZE.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 0, "inventorysize(apple) == 0");
        IValue res2 = Operators.OBJECT_ITEMSTACK_INVENTORYSIZE.evaluate(this.iShulkerBox);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 27, "inventory(shulkerbox) == 27");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeInventorySizeLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_INVENTORYSIZE.evaluate(this.iApple, this.int100);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeInventorySizeSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_INVENTORYSIZE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeInventorySize() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_INVENTORYSIZE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackInventory() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_INVENTORY.evaluate(this.iApple);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), 0, "inventory(apple).size == 0");
        IValue res2 = Operators.OBJECT_ITEMSTACK_INVENTORY.evaluate(this.iShulkerBox);
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res2).getRawValue().getLength(), 27, "inventory(shulkerbox).size == 27");
        IValue res3 = Operators.OBJECT_ITEMSTACK_INVENTORY.evaluate(this.iShulkerBox);
        TestHelpers.assertEqual(((ValueObjectTypeItemStack.ValueItemStack)((ValueTypeList.ValueList)res3).getRawValue().get(10)).getRawValue().getItem(), Items.APPLE, "inventory(shulkerbox)[10] == apple");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputInventoryLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_INVENTORY.evaluate(this.iApple, this.int100);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputInventorySmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_INVENTORY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeInventory() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_INVENTORY.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemItemByName() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_BY_NAME.evaluate(this.sApple);
        Asserts.check(res1 instanceof ValueObjectTypeItemStack.ValueItemStack, "result is a block");
        TestHelpers.assertEqual(((ValueObjectTypeItemStack.ValueItemStack)res1).getRawValue().getItem(), new ItemStack((ItemLike)Items.APPLE).getItem(), "itembyname(minecraft:apple) = apple");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeItemByNameLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_BY_NAME.evaluate(this.sApple, this.sApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeItemByNameSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_BY_NAME.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeItemByName() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_BY_NAME.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackListCount() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_LIST_COUNT.evaluate(this.lApples, this.iApple);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 7, "listcount(apple) = 7");
        IValue res2 = Operators.OBJECT_ITEMSTACK_LIST_COUNT.evaluate(this.lApples, this.iStone);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 0, "listcount(stone) = 0");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeListCountLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_LIST_COUNT.evaluate(this.lApples, this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeListCountSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_LIST_COUNT.evaluate(this.lApples);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeListCount() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_LIST_COUNT.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackNbt() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_DATA.evaluate(this.iAppleNoData);
        Asserts.check(res1 instanceof ValueTypeNbt.ValueNbt, "result is an nbt tag");
        TestHelpers.assertEqual(((ValueTypeNbt.ValueNbt)res1).getRawValue().isPresent(), false, "data(apple:1) is null");
        IValue res2 = Operators.OBJECT_ITEMSTACK_DATA.evaluate(this.iEnergyBatteryFull);
        TestHelpers.assertNonEqual((Tag)((ValueTypeNbt.ValueNbt)res2).getRawValue().get(), new CompoundTag(), "data(battery) is non null");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputNbtNbtLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DATA.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputNbtNbtSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DATA.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeNbt() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DATA.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackHasNbt() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_HASDATA.evaluate(this.iEmpty);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "hasdata(empty) = false");
        IValue res2 = Operators.OBJECT_ITEMSTACK_HASDATA.evaluate(this.iAppleTag);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "hasdata(appleTag) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputHasNbtHasNbtLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_HASDATA.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputHasNbtHasNbtSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_HASDATA.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeHasNbt() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_HASDATA.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackDataKeys() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_DATA_KEYS.evaluate(this.iEmpty);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), 0, "datakeys(empty) = []");
        IValue res2 = Operators.OBJECT_ITEMSTACK_DATA_KEYS.evaluate(this.iAppleTag);
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res2).getRawValue().getLength(), 13, "datakeys(appleTag).length = 13");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(0)).getRawValue(), "minecraft:attribute_modifiers", "datakeys(appleTag)[0] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(1)).getRawValue(), "minecraft:break_sound", "datakeys(appleTag)[1] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(2)).getRawValue(), "minecraft:consumable", "datakeys(appleTag)[2] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(3)).getRawValue(), "minecraft:enchantments", "datakeys(appleTag)[3] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(4)).getRawValue(), "minecraft:food", "datakeys(appleTag)[4] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(5)).getRawValue(), "minecraft:item_model", "datakeys(appleTag)[5] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(6)).getRawValue(), "minecraft:item_name", "datakeys(appleTag)[6] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(7)).getRawValue(), "minecraft:lore", "datakeys(appleTag)[7] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(8)).getRawValue(), "minecraft:max_stack_size", "datakeys(appleTag)[8] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(9)).getRawValue(), "minecraft:ominous_bottle_amplifier", "datakeys(appleTag)[9] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(10)).getRawValue(), "minecraft:rarity", "datakeys(appleTag)[10] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(11)).getRawValue(), "minecraft:repair_cost", "datakeys(appleTag)[11] == ...");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(12)).getRawValue(), "minecraft:tooltip_display", "datakeys(appleTag)[12] == ...");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputDataKeysDataKeysLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DATA_KEYS.evaluate(this.iApple, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputDataKeysDataKeysSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DATA_KEYS.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeDataKeys() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DATA_KEYS.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackDataValue() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_DATA_VALUE.evaluate(this.iAppleNoData, this.sMaxStackSize);
        Asserts.check(res1 instanceof ValueTypeNbt.ValueNbt, "result is an empty tag");
        TestHelpers.assertEqual(((ValueTypeNbt.ValueNbt)res1).getRawValue().isEmpty(), true, "datavalue(apple, maxstacksize) = empty");
        IValue res2 = Operators.OBJECT_ITEMSTACK_DATA_VALUE.evaluate(this.iAppleTag, this.sMaxStackSize);
        TestHelpers.assertEqual((Tag)((ValueTypeNbt.ValueNbt)res2).getRawValue().get(), IntTag.valueOf((int)64), "datavalue(appleTag, maxstacksize).length = 64");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputDataValueDataValueLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DATA_VALUE.evaluate(this.iApple, this.sMaxStackSize, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputDataValueDataValueSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DATA_VALUE.evaluate(this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeDataValue() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_DATA_VALUE.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackWithData() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_WITH_DATA.evaluate(this.iAppleNoData, this.sMaxStackSize, this.t4);
        Asserts.check(res1 instanceof ValueObjectTypeItemStack.ValueItemStack, "result is an item");
        ItemStack outItem1 = ((ValueObjectTypeItemStack.ValueItemStack)res1).getRawValue();
        TestHelpers.assertEqual(outItem1.getItem(), ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().getItem(), "withdata(apple, maxstacksize, 4) = apple");
        TestHelpers.assertNonEqual(outItem1.getComponents(), ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().getComponents(), "withdata(apple, maxstacksize, 4) !=components apple");
        TestHelpers.assertEqual((Integer)outItem1.get(DataComponents.MAX_STACK_SIZE), 4, "withdata(apple, maxstacksize, 4).maxstacksize = 4");
        IValue res2 = Operators.OBJECT_ITEMSTACK_WITH_DATA.evaluate(this.iAppleTag, this.sMaxStackSize, this.t4);
        ItemStack outItem2 = ((ValueObjectTypeItemStack.ValueItemStack)res2).getRawValue();
        TestHelpers.assertEqual(outItem2.getItem(), ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().getItem(), "withdata(appleTag, maxstacksize, 4) = apple");
        TestHelpers.assertNonEqual(outItem2.getComponents(), ((ValueObjectTypeItemStack.ValueItemStack)this.iAppleNoData.getValue()).getRawValue().getComponents(), "withdata(appleTag, maxstacksize, 4) !=components apple");
        TestHelpers.assertEqual((Integer)outItem2.get(DataComponents.MAX_STACK_SIZE), 4, "withdata(appleTag, maxstacksize, 4).maxstacksize = 4");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputWithDataWithDataLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_WITH_DATA.evaluate(this.iApple, this.sMaxStackSize, this.t4, this.iApple);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputWithDataWithDataSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_WITH_DATA.evaluate(this.iApple, this.sMaxStackSize);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeWithData() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_WITH_DATA.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testItemStackTooltip() throws EvaluationException {
        IValue res1 = Operators.OBJECT_ITEMSTACK_TOOLTIP.evaluate(this.iPickaxe);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), 5, "size(tooltip(pickaxe)) = 5");
        IValue res2 = Operators.OBJECT_ITEMSTACK_TOOLTIP.evaluate(this.iApple);
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res2).getRawValue().getLength(), 1, "size(tooltip(apple)) = 1");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTooltipLarge() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_TOOLTIP.evaluate(this.iPickaxe, this.iPickaxe);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTooltipSmall() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_TOOLTIP.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTooltip() throws EvaluationException {
        Operators.OBJECT_ITEMSTACK_TOOLTIP.evaluate(DUMMY_VARIABLE);
    }
}

