/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.entity.item.EntityItemTargetted;
import org.cyclops.integrateddynamics.inventory.container.ContainerOnTheDynamicsOfIntegration;
import org.cyclops.integrateddynamics.item.ItemOnTheDynamicsOfIntegrationConfig;

public class ItemOnTheDynamicsOfIntegration
extends ItemGui {
    private static final int SPAWN_RANGE = 25;
    private static final String NBT_INFOBOOK_SPAWNED = "integrateddynamics:infoBookSpawned";

    public ItemOnTheDynamicsOfIntegration(Item.Properties properties) {
        super(properties);
        NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, ItemLocation itemLocation) {
        return new NamedContainerProviderItem(itemLocation, (Component)Component.translatable((String)"gui.cyclopscore.infobook"), ContainerOnTheDynamicsOfIntegration::new);
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerOnTheDynamicsOfIntegration.class;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (ItemOnTheDynamicsOfIntegrationConfig.obtainOnSpawn) {
            CompoundTag playerTag;
            CompoundTag tag = event.getEntity().getPersistentData();
            if (!tag.contains("PlayerPersisted")) {
                tag.put("PlayerPersisted", (Tag)new CompoundTag());
            }
            if (!(playerTag = (CompoundTag)tag.getCompound("PlayerPersisted").orElseThrow()).contains(NBT_INFOBOOK_SPAWNED)) {
                playerTag.putBoolean(NBT_INFOBOOK_SPAWNED, true);
                Level world = event.getEntity().level();
                Player player = event.getEntity();
                ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ON_THE_DYNAMICS_OF_INTEGRATION);
                EntityItemTargetted entity = new EntityItemTargetted(world, (float)(player.blockPosition().getX() + 25) - 50.0f * world.random.nextFloat(), (float)player.blockPosition().getY() + 25.0f * world.random.nextFloat(), (float)(player.blockPosition().getZ() + 25) - 50.0f * world.random.nextFloat());
                entity.setItem(itemStack);
                entity.setTarget((LivingEntity)player);
                world.addFreshEntity((Entity)entity);
            }
        }
    }
}

