/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityMechanicalDryingBasin;

public class LootFunctionCopyMechanicalDryingBasinTanks
extends LootItemConditionalFunction {
    public static final MapCodec<LootFunctionCopyMechanicalDryingBasinTanks> CODEC = RecordCodecBuilder.mapCodec(builder -> LootFunctionCopyMechanicalDryingBasinTanks.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyMechanicalDryingBasinTanks::new));
    public static final LootItemFunctionType<LootFunctionCopyMechanicalDryingBasinTanks> TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyMechanicalDryingBasinTanks(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        BlockEntity tile = (BlockEntity)lootContext.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof BlockEntityMechanicalDryingBasin) {
            itemStack.set(RegistryEntries.DATACOMPONENT_FLUID_CONTENT_IN_OUT, (Object)Pair.of((Object)SimpleFluidContent.copyOf((FluidStack)((BlockEntityMechanicalDryingBasin)tile).getTankInput().getFluid()), (Object)SimpleFluidContent.copyOf((FluidStack)((BlockEntityMechanicalDryingBasin)tile).getTankOutput().getFluid())));
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return TYPE;
    }
}

