/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeCategory;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IOperatorVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.OperatorVariableFacade;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.OperatorLPElementRenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;

public class OperatorLPElement
implements ILogicProgrammerElement<RenderPattern, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase> {
    private final IOperator operator;
    private IVariableFacade[] inputVariables;
    private boolean focused = false;

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.OPERATOR;
    }

    @Override
    public String getMatchString() {
        return this.getOperator().getLocalizedNameFull().getString().toLowerCase();
    }

    @Override
    public boolean matchesInput(IValueType valueType) {
        for (IValueType operatorIn : this.getOperator().getInputTypes()) {
            if (!ValueHelpers.correspondsTo(operatorIn, valueType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesOutput(IValueType valueType) {
        return ValueHelpers.correspondsTo(this.getOperator().getOutputType(), valueType);
    }

    @Override
    public Component getName() {
        return this.getOperator().getLocalizedNameFull();
    }

    @Override
    public void loadTooltip(List<Component> lines) {
        this.getOperator().loadTooltip(lines, true);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        if (this.getOperator().getRenderPattern() == null) {
            throw new IllegalStateException("Tried to render a (possibly virtual) operator with a null render pattern: " + String.valueOf(this.getOperator().getUniqueName()));
        }
        return this.getOperator().getRenderPattern();
    }

    @Override
    public void onInputSlotUpdated(Player player, int slotId, ItemStack itemStack) {
        IVariableFacade variableFacade;
        this.inputVariables[slotId] = variableFacade = ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).handle(ValueDeseralizationContext.of(player.level()), itemStack);
    }

    @Override
    public boolean canWriteElementPre() {
        for (IVariableFacade inputVariable : this.inputVariables) {
            if (inputVariable != null && inputVariable.isValid()) continue;
            return false;
        }
        return true;
    }

    protected int[] getVariableIds(IVariableFacade[] inputVariables) {
        int[] variableIds = new int[inputVariables.length];
        for (int i = 0; i < inputVariables.length; ++i) {
            variableIds[i] = inputVariables[i].getId();
        }
        return variableIds;
    }

    @Override
    public ItemStack writeElement(Player player, ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        int[] variableIds = this.getVariableIds(this.inputVariables);
        return registry.writeVariableFacadeItem(!player.level().isClientSide(), itemStack, Operators.REGISTRY, new OperatorVariableFacadeFactory(this.operator, variableIds), player.level(), player, ((Block)RegistryEntries.BLOCK_LOGIC_PROGRAMMER.get()).defaultBlockState());
    }

    @Override
    public void loadElement(IVariableFacade variableFacade) {
        if (variableFacade instanceof OperatorVariableFacade) {
            OperatorVariableFacade operatorVariableFacade = (OperatorVariableFacade)variableFacade;
            int[] variableIds = operatorVariableFacade.getVariableIds();
            this.inputVariables = new IVariableFacade[variableIds.length];
            for (int i = 0; i < variableIds.length; ++i) {
                IValueType valueType = this.operator.getInputTypes()[i];
                if (valueType instanceof IValueTypeCategory) {
                    IValueTypeCategory valueTypeCategory = (IValueTypeCategory)valueType;
                    valueType = (IValueType)Iterables.getFirst(valueTypeCategory.getElements(), (Object)ValueTypes.BOOLEAN);
                }
                this.inputVariables[i] = new ValueTypeVariableFacade(variableIds[i], valueType, valueType.getDefault());
            }
        }
    }

    @Override
    public void setValueInGui(RenderPattern subGui) {
        this.setValueInContainer((ContainerLogicProgrammerBase)((Object)subGui.container));
    }

    @Override
    public void setValueInContainer(ContainerLogicProgrammerBase container) {
        SimpleInventory inputSlots = container.getTemporaryInputSlots();
        for (int i = 0; i < inputSlots.getContainerSize(); ++i) {
            ItemStack itemStack = ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).writeVariableFacadeItem(new ItemStack(RegistryEntries.ITEM_VARIABLE), this.inputVariables[i], ValueTypes.REGISTRY);
            inputSlots.setItem(i, itemStack);
        }
    }

    @Override
    public boolean canCurrentlyReadFromOtherItem() {
        return true;
    }

    @Override
    public void activate() {
        this.inputVariables = new IVariableFacade[this.getRenderPattern().getSlotPositions().length];
    }

    @Override
    public void deactivate() {
        this.inputVariables = null;
    }

    @Override
    public Component validate() {
        return this.getOperator().validateTypes(ValueHelpers.from(this.inputVariables));
    }

    @Override
    public int getColor() {
        return this.getOperator().getOutputType().getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return this.getOperator().getSymbol();
    }

    @Override
    public boolean isFor(IVariableFacade variableFacade) {
        IOperatorVariableFacade operatorFacade;
        if (variableFacade instanceof IOperatorVariableFacade && (operatorFacade = (IOperatorVariableFacade)variableFacade).isValid()) {
            return this.getOperator() == operatorFacade.getOperator();
        }
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return itemStack.getItem() == RegistryEntries.ITEM_VARIABLE.get();
    }

    @Override
    public boolean slotClick(int slotId, Slot slot, int mouseButton, ClickType clickType, Player player) {
        return false;
    }

    @Override
    public int getItemStackSizeLimit() {
        return 1;
    }

    @Override
    public boolean isFocused(RenderPattern subGui) {
        return this.focused;
    }

    @Override
    public void setFocused(RenderPattern subGui, boolean focused) {
        this.focused = focused;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderPattern createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        return new OperatorLPElementRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    public OperatorLPElement(IOperator operator) {
        this.operator = operator;
    }

    public IOperator getOperator() {
        return this.operator;
    }

    public IVariableFacade[] getInputVariables() {
        return this.inputVariables;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setInputVariables(IVariableFacade[] inputVariables) {
        this.inputVariables = inputVariables;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperatorLPElement)) {
            return false;
        }
        OperatorLPElement other = (OperatorLPElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFocused() != other.isFocused()) {
            return false;
        }
        IOperator this$operator = this.getOperator();
        IOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        return Arrays.deepEquals(this.getInputVariables(), other.getInputVariables());
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperatorLPElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFocused() ? 79 : 97);
        IOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInputVariables());
        return result;
    }

    public String toString() {
        return "OperatorLPElement(operator=" + String.valueOf(this.getOperator()) + ", inputVariables=" + Arrays.deepToString(this.getInputVariables()) + ", focused=" + this.isFocused() + ")";
    }

    public static class OperatorVariableFacadeFactory
    implements IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IOperatorVariableFacade> {
        private final IOperator operator;
        private final int[] variableIds;

        public OperatorVariableFacadeFactory(IOperator operator, int[] variableIds) {
            this.operator = operator;
            this.variableIds = variableIds;
        }

        @Override
        public IOperatorVariableFacade create(boolean generateId) {
            return new OperatorVariableFacade(generateId, this.operator, this.variableIds);
        }

        @Override
        public IOperatorVariableFacade create(int id) {
            return new OperatorVariableFacade(id, this.operator, this.variableIds);
        }
    }
}

