/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.evaluate.variable;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;

public interface IValueType<V extends IValue> {
    public boolean isCategory();

    public boolean isObject();

    public V getDefault();

    public String getTypeName();

    public ResourceLocation getUniqueName();

    public String getTranslationKey();

    public void loadTooltip(List<Component> var1, boolean var2, @Nullable V var3);

    public MutableComponent toCompactString(V var1);

    public int getDisplayColor();

    public ChatFormatting getDisplayColorFormat();

    public boolean correspondsTo(IValueType<?> var1);

    public Tag serialize(V var1);

    @Nullable
    public Component canDeserialize(ValueDeseralizationContext var1, Tag var2);

    public V deserialize(ValueDeseralizationContext var1, Tag var2);

    public V materialize(V var1) throws EvaluationException;

    public String toString(V var1);

    public V parseString(String var1) throws EvaluationException;

    public IValueTypeLogicProgrammerElement createLogicProgrammerElement();

    default public ValuePredicate<V> deserializeValuePredicate(JsonObject element, @Nullable IValue value) {
        return new ValuePredicate(this, value);
    }

    public V cast(IValue var1) throws EvaluationException;

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    default public BakedModel getVariableItemOverrideModel(V value, BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderISTER(V value, ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
    }

    public static class ValueTypeComparator
    implements Comparator<IValueType<?>> {
        private static ValueTypeComparator INSTANCE = null;

        private ValueTypeComparator() {
        }

        public static ValueTypeComparator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new ValueTypeComparator();
            }
            return INSTANCE;
        }

        @Override
        public int compare(IValueType<?> o1, IValueType<?> o2) {
            return o1.getUniqueName().compareTo(o2.getUniqueName());
        }
    }
}

