/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.StringUtils;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class NbtValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    private static final int MAX_LINES = 30;
    private static final float MAX = 12.5f;
    private static final float MARGIN_FACTOR = 1.1f;

    @Override
    public void renderValue(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        Font fontRenderer = context.m_173586_();
        Wrapper maxWidth = new Wrapper((Object)Float.valueOf(0.0f));
        LinkedList lines = Lists.newLinkedList();
        ((ValueTypeNbt.ValueNbt)value).getRawValue().ifPresent(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag tagCompound = (CompoundTag)tag;
                lines.add("{");
                for (String key : tagCompound.m_128431_()) {
                    if (lines.size() >= 30) {
                        lines.add("...");
                        break;
                    }
                    Tag subTag = ValueTypes.NBT.filterBlacklistedTags(tagCompound.m_128423_(key));
                    String string = "  " + key + ": " + StringUtils.abbreviate((String)subTag.toString(), (int)40);
                    float width = fontRenderer.m_92895_(string) - 1;
                    lines.add(string);
                    maxWidth.set((Object)Float.valueOf(Math.max(((Float)maxWidth.get()).floatValue(), width)));
                }
                lines.add("}");
            } else {
                String string = tag.toString();
                lines.add(string);
                maxWidth.set((Object)Float.valueOf(fontRenderer.m_92895_(string) - 1));
            }
        });
        Objects.requireNonNull(fontRenderer);
        float singleHeight = 9.0f;
        float totalHeight = singleHeight * (float)lines.size();
        matrixStack.m_85836_();
        float scaleX = 12.5f / (((Float)maxWidth.get()).floatValue() * 1.1f);
        float scaleY = 12.5f / (totalHeight * 1.1f);
        float scale = Math.min(scaleX, scaleY);
        float newWidth = ((Float)maxWidth.get()).floatValue() * scale;
        float newHeight = totalHeight * scale;
        matrixStack.m_252880_((12.5f - newWidth) / 2.0f, (12.5f - newHeight) / 2.0f, 0.0f);
        matrixStack.m_85841_(scale, scale, 1.0f);
        int offset = 0;
        for (String line : lines) {
            int color = Helpers.addAlphaToColor((int)ValueTypes.NBT.getDisplayColor(), (float)alpha);
            context.m_173586_().m_271703_(line, 0.0f, (float)offset, color, false, matrixStack.m_85850_().m_252922_(), renderTypeBuffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            offset = (int)((float)offset + singleHeight);
        }
        matrixStack.m_85849_();
    }
}

