/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.blockentity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.network.MechanicalMachineNetworkElement;

public abstract class BlockEntityMechanicalMachine<RCK, R extends Recipe>
extends BlockEntityCableConnectableInventory
implements IEnergyStorage {
    private static int SLEEP_TIME = 40;
    @NBTPersist
    private int energy;
    @NBTPersist
    private int progress = -1;
    @NBTPersist
    private int sleep = -1;
    private SingleCache<RCK, Optional<R>> recipeCache;

    public BlockEntityMechanicalMachine(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize) {
        super(type, blockPos, blockState, inventorySize, 64);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new MechanicalMachineNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        }));
        this.addCapabilityInternal(ForgeCapabilities.ENERGY, LazyOptional.of(() -> this));
        LazyOptional itemHandlerInput = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), this.getInputSlots()));
        LazyOptional itemHandlerOutput = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), this.getOutputSlots()));
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.UP, itemHandlerInput);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN, itemHandlerOutput);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.NORTH, itemHandlerInput);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.SOUTH, itemHandlerInput);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.WEST, itemHandlerInput);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.EAST, itemHandlerInput);
        this.recipeCache = new SingleCache(this.createCacheUpdater());
    }

    protected abstract SingleCache.ICacheUpdater<RCK, Optional<R>> createCacheUpdater();

    public abstract int[] getInputSlots();

    public abstract int[] getOutputSlots();

    public abstract boolean wasWorking();

    public abstract void setWorking(boolean var1);

    public boolean hasWork() {
        return this.getCurrentRecipe() != null;
    }

    public boolean isWorking() {
        return this.progress >= 0 && this.sleep == -1;
    }

    public boolean canWork() {
        int rate = this.getEnergyConsumptionRate();
        return this.drainEnergy(rate, true) == rate && !this.f_58857_.m_276867_(this.m_58899_());
    }

    public boolean isSleeping() {
        return this.sleep > 0;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public int getSleep() {
        return this.sleep;
    }

    public LazyOptional<IEnergyNetwork> getEnergyNetwork() {
        return NetworkHelpers.getEnergyNetwork(this.getNetwork());
    }

    public void onTankChanged() {
        this.m_6596_();
        this.getInventory().m_6596_();
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean m_7013_(int i, ItemStack itemstack) {
                return ArrayUtils.contains((int[])BlockEntityMechanicalMachine.this.getInputSlots(), (int)i) && super.m_7013_(i, itemstack);
            }

            protected void onInventoryChanged() {
                super.onInventoryChanged();
                BlockEntityMechanicalMachine.this.sleep = -1;
            }
        };
    }

    protected abstract RecipeType<? extends R> getRecipeRegistry();

    protected abstract RCK getCurrentRecipeCacheKey();

    public Optional<R> getCurrentRecipe() {
        return (Optional)this.recipeCache.get(this.getCurrentRecipeCacheKey());
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.getCurrentRecipe().map(this::getRecipeDuration).orElse(0);
    }

    public abstract int getRecipeDuration(R var1);

    protected abstract boolean finalizeRecipe(R var1, boolean var2);

    public void updateWorkingState() {
        boolean wasWorking = this.wasWorking();
        boolean isWorking = this.isWorking();
        if (isWorking != wasWorking) {
            this.setWorking(isWorking);
        }
    }

    public abstract int getEnergyConsumptionRate();

    protected int drainEnergy(int amount, boolean simulate) {
        IEnergyNetwork energyNetwork;
        int toDrain = amount;
        if ((toDrain -= this.extractEnergyInternal(toDrain, simulate)) > 0 && (energyNetwork = (IEnergyNetwork)this.getEnergyNetwork().orElse(null)) != null) {
            toDrain = (int)((long)toDrain - (Long)energyNetwork.getChannel(0).extract((long)toDrain, simulate));
        }
        return amount - toDrain;
    }

    protected int extractEnergyInternal(int energy, boolean simulate) {
        energy = Math.max(0, energy);
        int stored = this.getEnergyStored();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(newEnergy);
        }
        return stored - newEnergy;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        int lastEnergy = this.energy;
        if (lastEnergy != energy) {
            this.energy = energy;
            this.m_6596_();
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int stored = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - stored, maxReceive);
        if (!simulate) {
            this.setEnergy(stored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public static class Ticker<RCK, R extends Recipe, BE extends BlockEntityMechanicalMachine<RCK, R>>
    extends BlockEntityCableConnectableInventory.Ticker<BE> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BE blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityMechanicalMachine)((Object)blockEntity)).isSleeping()) {
                ((BlockEntityMechanicalMachine)((Object)blockEntity)).setSleep(((BlockEntityMechanicalMachine)((Object)blockEntity)).getSleep() - 1);
                blockEntity.m_6596_();
            } else if (((BlockEntityMechanicalMachine)((Object)blockEntity)).canWork()) {
                Optional recipeOptional = ((BlockEntityMechanicalMachine)((Object)blockEntity)).getCurrentRecipe();
                if (recipeOptional.isPresent()) {
                    Recipe recipe = (Recipe)recipeOptional.get();
                    if (((BlockEntityMechanicalMachine)((Object)blockEntity)).getProgress() == 0 && !((BlockEntityMechanicalMachine)((Object)blockEntity)).finalizeRecipe((Recipe)recipe, true)) {
                        ((BlockEntityMechanicalMachine)((Object)blockEntity)).setSleep(SLEEP_TIME);
                    } else if (((BlockEntityMechanicalMachine)((Object)blockEntity)).getProgress() < ((BlockEntityMechanicalMachine)((Object)blockEntity)).getMaxProgress()) {
                        int toDrain = ((BlockEntityMechanicalMachine)((Object)blockEntity)).getEnergyConsumptionRate();
                        if (((BlockEntityMechanicalMachine)((Object)blockEntity)).drainEnergy(toDrain, true) == toDrain) {
                            ((BlockEntityMechanicalMachine)((Object)blockEntity)).drainEnergy(toDrain, false);
                            ((BlockEntityMechanicalMachine)((Object)blockEntity)).setProgress(((BlockEntityMechanicalMachine)((Object)blockEntity)).getProgress() + 1);
                            ((BlockEntityMechanicalMachine)((Object)blockEntity)).setSleep(-1);
                        } else {
                            ((BlockEntityMechanicalMachine)((Object)blockEntity)).setSleep(1);
                        }
                    } else if (((BlockEntityMechanicalMachine)((Object)blockEntity)).finalizeRecipe((Recipe)recipe, true)) {
                        ((BlockEntityMechanicalMachine)((Object)blockEntity)).setProgress(0);
                        ((BlockEntityMechanicalMachine)((Object)blockEntity)).finalizeRecipe((Recipe)recipe, false);
                    } else {
                        ((BlockEntityMechanicalMachine)((Object)blockEntity)).setSleep(40);
                    }
                } else {
                    ((BlockEntityMechanicalMachine)((Object)blockEntity)).setProgress(-1);
                    ((BlockEntityMechanicalMachine)((Object)blockEntity)).setSleep(-1);
                }
            }
            ((BlockEntityMechanicalMachine)((Object)blockEntity)).updateWorkingState();
        }
    }
}

