/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.blockentity.BlockEntityMechanicalSqueezer;
import org.cyclops.integrateddynamicscompat.modcompat.jade.SqueezerDataProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class MechanicalSqueezerDataProvider
extends SqueezerDataProvider {
    public static final ResourceLocation ID = new ResourceLocation("integrateddynamicscompat", "mechanical_squeezer");

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (config.get(ID)) {
            tooltip.addAll((List)NBTClassType.getClassType(List.class).readPersistedField("tooltip", accessor.getServerData()));
        }
    }

    @Override
    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BlockEntityMechanicalSqueezer tile = (BlockEntityMechanicalSqueezer)accessor.getBlockEntity();
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(Component.m_237110_((String)"gui.integrateddynamics.waila.energy", (Object[])new Object[]{tile.getEnergyStored(), tile.getMaxEnergyStored()}));
        if (!tile.getInventory().m_8020_(0).m_41619_()) {
            tooltip.add(Component.m_237110_((String)"gui.integrateddynamics.waila.item.in", (Object[])new Object[]{tile.getInventory().m_8020_(0).m_41611_()}));
        }
        for (int i = 1; i < tile.getInventory().m_6643_(); ++i) {
            if (tile.getInventory().m_8020_(i).m_41619_()) continue;
            tooltip.add(Component.m_237110_((String)"gui.integrateddynamics.waila.item.out", (Object[])new Object[]{tile.getInventory().m_8020_(i).m_41611_()}));
        }
        if (!tile.getTank().isEmpty()) {
            tooltip.add(Component.m_237110_((String)"gui.integrateddynamics.waila.fluid", (Object[])new Object[]{tile.getTank().getFluid().getDisplayName(), tile.getTank().getFluidAmount()}));
        }
        if (tile.getProgress() > 0) {
            tooltip.add(Component.m_237110_((String)"gui.integrateddynamics.waila.progress", (Object[])new Object[]{tile.getProgress() * 100 / tile.getMaxProgress()}));
        }
        NBTClassType.getClassType(List.class).writePersistedField("tooltip", (Object)tooltip, tag);
    }

    @Override
    public ResourceLocation getUid() {
        return ID;
    }
}

