/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.jetbrains.annotations.Nullable;

public class VanillaRecipeTypeRecipeHandler<C extends Container, T extends Recipe<C>>
implements IRecipeHandler {
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_INPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_OUTPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    public static final AbstractContainerMenu DUMMY_CONTAINTER = new AbstractContainerMenu(MenuType.f_39968_, 0){

        public ItemStack m_7648_(Player p_38941_, int p_38942_) {
            return ItemStack.f_41583_;
        }

        public boolean m_6875_(Player playerIn) {
            return true;
        }
    };
    private final Supplier<Level> worldSupplier;
    private final RecipeType<T> recipeType;
    private final Predicate<Integer> inputSizePredicate;
    private final boolean ignoreEmptySlots;
    private final boolean checkOutput;
    public static Map<Pair<RecipeType<?>, ResourceLocation>, Collection<IRecipeDefinition>> CACHED_RECIPES = Maps.newHashMap();

    public VanillaRecipeTypeRecipeHandler(Supplier<Level> worldSupplier, RecipeType<T> recipeType, Predicate<Integer> inputSizePredicate, boolean ignoreEmptySlots, boolean checkOutput) {
        this.worldSupplier = worldSupplier;
        this.recipeType = recipeType;
        this.inputSizePredicate = inputSizePredicate;
        this.ignoreEmptySlots = ignoreEmptySlots;
        this.checkOutput = checkOutput;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return COMPONENTS_INPUT;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return COMPONENTS_OUTPUT;
    }

    public boolean isValidSizeInput(IngredientComponent component, int size) {
        return component == IngredientComponent.ITEMSTACK && this.inputSizePredicate.test(size);
    }

    public static List<IPrototypedIngredient<ItemStack, Integer>> getPrototypesFromIngredient(Ingredient ingredient) {
        if (ingredient instanceof StrictNBTIngredient || ingredient instanceof PartialNBTIngredient) {
            return Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ingredient.m_43908_()[0], 5)});
        }
        return Arrays.stream(ingredient.m_43908_()).map(itemStack -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)itemStack, 1)).collect(Collectors.toList());
    }

    @javax.annotation.Nullable
    public static <C extends Container, T extends Recipe<C>> IRecipeDefinition recipeToRecipeDefinition(T recipe, Level level) {
        if (recipe.m_8043_(level.m_9598_()).m_41619_()) {
            return null;
        }
        int inputSize = recipe.m_7527_().size();
        ArrayList inputIngredients = Lists.newArrayListWithCapacity((int)inputSize);
        if (inputSize == 0) {
            return null;
        }
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            inputIngredients = Lists.newArrayListWithCapacity((int)9);
            for (int h = 0; h < 3; ++h) {
                for (int w = 0; w < 3; ++w) {
                    if (h < shapedRecipe.m_44221_() && w < shapedRecipe.m_44220_()) {
                        inputIngredients.add(VanillaRecipeTypeRecipeHandler.getRecipeInputPrototypes(recipe, w + h * shapedRecipe.m_44220_()));
                        continue;
                    }
                    inputIngredients.add(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ItemStack.f_41583_, 1)}));
                }
            }
        } else {
            for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                inputIngredients.add(i, VanillaRecipeTypeRecipeHandler.getRecipeInputPrototypes(recipe, i));
            }
        }
        return RecipeDefinition.ofIngredients(IngredientComponent.ITEMSTACK, inputIngredients, MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, recipe.m_8043_(level.m_9598_())));
    }

    protected static <C extends Container, T extends Recipe<C>> List<IPrototypedIngredient<ItemStack, Integer>> getRecipeInputPrototypes(T recipe, int index) {
        Ingredient ingredient = (Ingredient)recipe.m_7527_().get(index);
        List<IPrototypedIngredient<ItemStack, Integer>> prototypes = VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient(ingredient);
        if (prototypes.isEmpty()) {
            prototypes.add(new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ItemStack.f_41583_, 1));
        }
        return prototypes;
    }

    @Override
    public Collection<IRecipeDefinition> getRecipes() {
        Pair cacheKey = Pair.of(this.recipeType, (Object)this.worldSupplier.get().m_46472_().m_135782_());
        Collection cached = CACHED_RECIPES.get(cacheKey);
        if (cached == null) {
            cached = this.worldSupplier.get().m_7465_().m_44051_().stream().filter(recipe -> recipe.m_6671_() == this.recipeType).map(recipe -> VanillaRecipeTypeRecipeHandler.recipeToRecipeDefinition(recipe, this.worldSupplier.get())).filter(Objects::nonNull).collect(Collectors.toList());
            CACHED_RECIPES.put(cacheKey, cached);
        }
        return cached;
    }

    @Override
    @javax.annotation.Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        List<ItemStack> recipeIngredients = input.getInstances(IngredientComponent.ITEMSTACK);
        if (this.ignoreEmptySlots) {
            recipeIngredients = recipeIngredients.stream().filter(itemStack -> !itemStack.m_41619_()).toList();
        }
        if (input.getComponents().size() != 1 || recipeIngredients.isEmpty()) {
            return null;
        }
        TransientCraftingContainer inventoryCrafting = new TransientCraftingContainer(DUMMY_CONTAINTER, 3, 3);
        for (int i = 0; i < recipeIngredients.size(); ++i) {
            inventoryCrafting.m_6836_(i, recipeIngredients.get(i));
        }
        Recipe recipe = CraftingHelpers.findRecipeCached(this.recipeType, (Container)inventoryCrafting, (Level)this.worldSupplier.get(), (boolean)true).orElse(null);
        if (recipe == null) {
            if (recipeIngredients.size() <= 4) {
                TransientCraftingContainer inventoryCraftingSmall = new TransientCraftingContainer(DUMMY_CONTAINTER, 2, 2);
                for (int i = 0; i < recipeIngredients.size(); ++i) {
                    inventoryCraftingSmall.m_6836_(i, recipeIngredients.get(i));
                }
                recipe = CraftingHelpers.findRecipeCached(this.recipeType, (Container)inventoryCraftingSmall, (Level)this.worldSupplier.get(), (boolean)true).orElse(null);
            }
            if (recipe == null) {
                return null;
            }
        }
        return MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, recipe.m_8043_(this.worldSupplier.get().m_9598_()));
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public IMixedIngredients simulate(IRecipeDefinition recipe) {
        MixedIngredients input = MixedIngredients.fromRecipeInput(recipe);
        if (this.checkOutput) {
            List<ItemStack> recipeIngredients = input.getInstances(IngredientComponent.ITEMSTACK);
            if (this.ignoreEmptySlots) {
                recipeIngredients = recipeIngredients.stream().filter(itemStack -> !itemStack.m_41619_()).toList();
            }
            if (input.getComponents().size() != 1 || recipeIngredients.isEmpty()) {
                return null;
            }
            TransientCraftingContainer inventoryCrafting = new TransientCraftingContainer(DUMMY_CONTAINTER, 3, 3);
            for (int i = 0; i < recipeIngredients.size(); ++i) {
                inventoryCrafting.m_6836_(i, recipeIngredients.get(i));
            }
            IMixedIngredients output = recipe.getOutput();
            List<ItemStack> recipeOutputs = output.getInstances(IngredientComponent.ITEMSTACK);
            if (output.getComponents().size() != 1 || recipeOutputs.size() != 1) {
                return null;
            }
            ItemStack recipeOutput = recipeOutputs.get(0);
            Level level = this.worldSupplier.get();
            return CraftingHelpers.findRecipes((Level)level, this.recipeType).stream().filter(arg_0 -> VanillaRecipeTypeRecipeHandler.lambda$simulate$5((CraftingContainer)inventoryCrafting, level, recipeOutput, arg_0)).findFirst().map(recipeHolder -> MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, recipeHolder.m_8043_(this.worldSupplier.get().m_9598_()))).orElse(null);
        }
        return this.simulate(input);
    }

    private static /* synthetic */ boolean lambda$simulate$5(CraftingContainer inventoryCrafting, Level level, ItemStack recipeOutput, Recipe recipeHolder) {
        return recipeHolder.m_5818_((Container)inventoryCrafting, level) && ItemStack.m_150942_((ItemStack)recipeHolder.m_8043_(level.m_9598_()), (ItemStack)recipeOutput);
    }
}

